package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{
  CustomPropertyValue,
  CustomPropertyKey,
  TokenUrl
}
import scala.jdk.CollectionConverters._
final case class OAuth2Properties(
    tokenUrl: TokenUrl,
    oAuth2GrantType: zio.aws.appflow.model.OAuth2GrantType,
    tokenUrlCustomProperties: Optional[
      Map[CustomPropertyKey, CustomPropertyValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.OAuth2Properties = {
    import OAuth2Properties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.OAuth2Properties
      .builder()
      .tokenUrl(TokenUrl.unwrap(tokenUrl): java.lang.String)
      .oAuth2GrantType(oAuth2GrantType.unwrap)
      .optionallyWith(
        tokenUrlCustomProperties.map(value =>
          value
            .map({ case (key, value) =>
              (CustomPropertyKey
                .unwrap(key): java.lang.String) -> (CustomPropertyValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tokenUrlCustomProperties)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.OAuth2Properties.ReadOnly =
    zio.aws.appflow.model.OAuth2Properties.wrap(buildAwsValue())
}
object OAuth2Properties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.OAuth2Properties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.OAuth2Properties =
      zio.aws.appflow.model.OAuth2Properties(
        tokenUrl,
        oAuth2GrantType,
        tokenUrlCustomProperties.map(value => value)
      )
    def tokenUrl: TokenUrl
    def oAuth2GrantType: zio.aws.appflow.model.OAuth2GrantType
    def tokenUrlCustomProperties
        : Optional[Map[CustomPropertyKey, CustomPropertyValue]]
    def getTokenUrl: ZIO[Any, Nothing, TokenUrl] = ZIO.succeed(tokenUrl)
    def getOAuth2GrantType
        : ZIO[Any, Nothing, zio.aws.appflow.model.OAuth2GrantType] =
      ZIO.succeed(oAuth2GrantType)
    def getTokenUrlCustomProperties
        : ZIO[Any, AwsError, Map[CustomPropertyKey, CustomPropertyValue]] =
      AwsError.unwrapOptionField(
        "tokenUrlCustomProperties",
        tokenUrlCustomProperties
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.OAuth2Properties
  ) extends zio.aws.appflow.model.OAuth2Properties.ReadOnly {
    override val tokenUrl: TokenUrl =
      zio.aws.appflow.model.primitives.TokenUrl(impl.tokenUrl())
    override val oAuth2GrantType: zio.aws.appflow.model.OAuth2GrantType =
      zio.aws.appflow.model.OAuth2GrantType.wrap(impl.oAuth2GrantType())
    override val tokenUrlCustomProperties
        : Optional[Map[CustomPropertyKey, CustomPropertyValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tokenUrlCustomProperties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.appflow.model.primitives.CustomPropertyKey(
                key
              ) -> zio.aws.appflow.model.primitives.CustomPropertyValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.OAuth2Properties
  ): zio.aws.appflow.model.OAuth2Properties.ReadOnly = new Wrapper(impl)
}
