package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.{OAuthScope, AuthCodeUrl, TokenUrl}
import scala.jdk.CollectionConverters._
final case class OAuthProperties(
    tokenUrl: TokenUrl,
    authCodeUrl: AuthCodeUrl,
    oAuthScopes: Iterable[OAuthScope]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.OAuthProperties = {
    import OAuthProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.OAuthProperties
      .builder()
      .tokenUrl(TokenUrl.unwrap(tokenUrl): java.lang.String)
      .authCodeUrl(AuthCodeUrl.unwrap(authCodeUrl): java.lang.String)
      .oAuthScopes(oAuthScopes.map { item =>
        OAuthScope.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.OAuthProperties.ReadOnly =
    zio.aws.appflow.model.OAuthProperties.wrap(buildAwsValue())
}
object OAuthProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.OAuthProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.OAuthProperties =
      zio.aws.appflow.model.OAuthProperties(tokenUrl, authCodeUrl, oAuthScopes)
    def tokenUrl: TokenUrl
    def authCodeUrl: AuthCodeUrl
    def oAuthScopes: List[OAuthScope]
    def getTokenUrl: ZIO[Any, Nothing, TokenUrl] = ZIO.succeed(tokenUrl)
    def getAuthCodeUrl: ZIO[Any, Nothing, AuthCodeUrl] =
      ZIO.succeed(authCodeUrl)
    def getOAuthScopes: ZIO[Any, Nothing, List[OAuthScope]] =
      ZIO.succeed(oAuthScopes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.OAuthProperties
  ) extends zio.aws.appflow.model.OAuthProperties.ReadOnly {
    override val tokenUrl: TokenUrl =
      zio.aws.appflow.model.primitives.TokenUrl(impl.tokenUrl())
    override val authCodeUrl: AuthCodeUrl =
      zio.aws.appflow.model.primitives.AuthCodeUrl(impl.authCodeUrl())
    override val oAuthScopes: List[OAuthScope] = impl
      .oAuthScopes()
      .asScala
      .map { item =>
        zio.aws.appflow.model.primitives.OAuthScope(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.OAuthProperties
  ): zio.aws.appflow.model.OAuthProperties.ReadOnly = new Wrapper(impl)
}
