package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PrefixConfig(
    prefixType: Optional[zio.aws.appflow.model.PrefixType] = Optional.Absent,
    prefixFormat: Optional[zio.aws.appflow.model.PrefixFormat] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.PrefixConfig = {
    import PrefixConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.PrefixConfig
      .builder()
      .optionallyWith(prefixType.map(value => value.unwrap))(_.prefixType)
      .optionallyWith(prefixFormat.map(value => value.unwrap))(_.prefixFormat)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.PrefixConfig.ReadOnly =
    zio.aws.appflow.model.PrefixConfig.wrap(buildAwsValue())
}
object PrefixConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.PrefixConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.PrefixConfig =
      zio.aws.appflow.model.PrefixConfig(
        prefixType.map(value => value),
        prefixFormat.map(value => value)
      )
    def prefixType: Optional[zio.aws.appflow.model.PrefixType]
    def prefixFormat: Optional[zio.aws.appflow.model.PrefixFormat]
    def getPrefixType: ZIO[Any, AwsError, zio.aws.appflow.model.PrefixType] =
      AwsError.unwrapOptionField("prefixType", prefixType)
    def getPrefixFormat
        : ZIO[Any, AwsError, zio.aws.appflow.model.PrefixFormat] =
      AwsError.unwrapOptionField("prefixFormat", prefixFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.PrefixConfig
  ) extends zio.aws.appflow.model.PrefixConfig.ReadOnly {
    override val prefixType: Optional[zio.aws.appflow.model.PrefixType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixType())
        .map(value => zio.aws.appflow.model.PrefixType.wrap(value))
    override val prefixFormat: Optional[zio.aws.appflow.model.PrefixFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixFormat())
        .map(value => zio.aws.appflow.model.PrefixFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.PrefixConfig
  ): zio.aws.appflow.model.PrefixConfig.ReadOnly = new Wrapper(impl)
}
