package zio.aws.appflow.model
import scala.jdk.CollectionConverters._
sealed trait PrefixFormat {
  def unwrap: software.amazon.awssdk.services.appflow.model.PrefixFormat
}
object PrefixFormat {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.PrefixFormat
  ): zio.aws.appflow.model.PrefixFormat = value match {
    case software.amazon.awssdk.services.appflow.model.PrefixFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.PrefixFormat.YEAR =>
      val r = YEAR
      r
    case software.amazon.awssdk.services.appflow.model.PrefixFormat.MONTH =>
      val r = MONTH
      r
    case software.amazon.awssdk.services.appflow.model.PrefixFormat.DAY =>
      val r = DAY
      r
    case software.amazon.awssdk.services.appflow.model.PrefixFormat.HOUR =>
      val r = HOUR
      r
    case software.amazon.awssdk.services.appflow.model.PrefixFormat.MINUTE =>
      val r = MINUTE
      r
  }
  case object unknownToSdkVersion extends zio.aws.appflow.model.PrefixFormat {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.PrefixFormat =
      software.amazon.awssdk.services.appflow.model.PrefixFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object YEAR extends zio.aws.appflow.model.PrefixFormat {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.PrefixFormat =
      software.amazon.awssdk.services.appflow.model.PrefixFormat.YEAR
  }
  case object MONTH extends zio.aws.appflow.model.PrefixFormat {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.PrefixFormat =
      software.amazon.awssdk.services.appflow.model.PrefixFormat.MONTH
  }
  case object DAY extends zio.aws.appflow.model.PrefixFormat {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.PrefixFormat =
      software.amazon.awssdk.services.appflow.model.PrefixFormat.DAY
  }
  case object HOUR extends zio.aws.appflow.model.PrefixFormat {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.PrefixFormat =
      software.amazon.awssdk.services.appflow.model.PrefixFormat.HOUR
  }
  case object MINUTE extends zio.aws.appflow.model.PrefixFormat {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.PrefixFormat =
      software.amazon.awssdk.services.appflow.model.PrefixFormat.MINUTE
  }
}
