package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.PrivateConnectionProvisioningFailureMessage
import scala.jdk.CollectionConverters._
final case class PrivateConnectionProvisioningState(
    status: Optional[
      zio.aws.appflow.model.PrivateConnectionProvisioningStatus
    ] = Optional.Absent,
    failureMessage: Optional[PrivateConnectionProvisioningFailureMessage] =
      Optional.Absent,
    failureCause: Optional[
      zio.aws.appflow.model.PrivateConnectionProvisioningFailureCause
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.PrivateConnectionProvisioningState = {
    import PrivateConnectionProvisioningState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.PrivateConnectionProvisioningState
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        failureMessage.map(value =>
          PrivateConnectionProvisioningFailureMessage.unwrap(
            value
          ): java.lang.String
        )
      )(_.failureMessage)
      .optionallyWith(failureCause.map(value => value.unwrap))(_.failureCause)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.PrivateConnectionProvisioningState.ReadOnly =
    zio.aws.appflow.model.PrivateConnectionProvisioningState
      .wrap(buildAwsValue())
}
object PrivateConnectionProvisioningState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.PrivateConnectionProvisioningState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.PrivateConnectionProvisioningState =
      zio.aws.appflow.model.PrivateConnectionProvisioningState(
        status.map(value => value),
        failureMessage.map(value => value),
        failureCause.map(value => value)
      )
    def status
        : Optional[zio.aws.appflow.model.PrivateConnectionProvisioningStatus]
    def failureMessage: Optional[PrivateConnectionProvisioningFailureMessage]
    def failureCause: Optional[
      zio.aws.appflow.model.PrivateConnectionProvisioningFailureCause
    ]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.PrivateConnectionProvisioningStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getFailureMessage
        : ZIO[Any, AwsError, PrivateConnectionProvisioningFailureMessage] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getFailureCause: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.PrivateConnectionProvisioningFailureCause
    ] = AwsError.unwrapOptionField("failureCause", failureCause)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.PrivateConnectionProvisioningState
  ) extends zio.aws.appflow.model.PrivateConnectionProvisioningState.ReadOnly {
    override val status
        : Optional[zio.aws.appflow.model.PrivateConnectionProvisioningStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.appflow.model.PrivateConnectionProvisioningStatus.wrap(value)
        )
    override val failureMessage
        : Optional[PrivateConnectionProvisioningFailureMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureMessage())
        .map(value =>
          zio.aws.appflow.model.primitives
            .PrivateConnectionProvisioningFailureMessage(value)
        )
    override val failureCause: Optional[
      zio.aws.appflow.model.PrivateConnectionProvisioningFailureCause
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failureCause())
      .map(value =>
        zio.aws.appflow.model.PrivateConnectionProvisioningFailureCause
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.PrivateConnectionProvisioningState
  ): zio.aws.appflow.model.PrivateConnectionProvisioningState.ReadOnly =
    new Wrapper(impl)
}
