package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.{Password, Username}
import scala.jdk.CollectionConverters._
final case class RedshiftConnectorProfileCredentials(
    username: Username,
    password: Password
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.RedshiftConnectorProfileCredentials = {
    import RedshiftConnectorProfileCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.RedshiftConnectorProfileCredentials
      .builder()
      .username(Username.unwrap(username): java.lang.String)
      .password(Password.unwrap(password): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.RedshiftConnectorProfileCredentials.ReadOnly =
    zio.aws.appflow.model.RedshiftConnectorProfileCredentials
      .wrap(buildAwsValue())
}
object RedshiftConnectorProfileCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.RedshiftConnectorProfileCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.RedshiftConnectorProfileCredentials =
      zio.aws.appflow.model
        .RedshiftConnectorProfileCredentials(username, password)
    def username: Username
    def password: Password
    def getUsername: ZIO[Any, Nothing, Username] = ZIO.succeed(username)
    def getPassword: ZIO[Any, Nothing, Password] = ZIO.succeed(password)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.RedshiftConnectorProfileCredentials
  ) extends zio.aws.appflow.model.RedshiftConnectorProfileCredentials.ReadOnly {
    override val username: Username =
      zio.aws.appflow.model.primitives.Username(impl.username())
    override val password: Password =
      zio.aws.appflow.model.primitives.Password(impl.password())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.RedshiftConnectorProfileCredentials
  ): zio.aws.appflow.model.RedshiftConnectorProfileCredentials.ReadOnly =
    new Wrapper(impl)
}
