package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{Description, ConnectorLabel}
import scala.jdk.CollectionConverters._
final case class RegisterConnectorRequest(
    connectorLabel: Optional[ConnectorLabel] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    connectorProvisioningType: Optional[
      zio.aws.appflow.model.ConnectorProvisioningType
    ] = Optional.Absent,
    connectorProvisioningConfig: Optional[
      zio.aws.appflow.model.ConnectorProvisioningConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.RegisterConnectorRequest = {
    import RegisterConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.RegisterConnectorRequest
      .builder()
      .optionallyWith(
        connectorLabel.map(value =>
          ConnectorLabel.unwrap(value): java.lang.String
        )
      )(_.connectorLabel)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(connectorProvisioningType.map(value => value.unwrap))(
        _.connectorProvisioningType
      )
      .optionallyWith(
        connectorProvisioningConfig.map(value => value.buildAwsValue())
      )(_.connectorProvisioningConfig)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.RegisterConnectorRequest.ReadOnly =
    zio.aws.appflow.model.RegisterConnectorRequest.wrap(buildAwsValue())
}
object RegisterConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.RegisterConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.RegisterConnectorRequest =
      zio.aws.appflow.model.RegisterConnectorRequest(
        connectorLabel.map(value => value),
        description.map(value => value),
        connectorProvisioningType.map(value => value),
        connectorProvisioningConfig.map(value => value.asEditable)
      )
    def connectorLabel: Optional[ConnectorLabel]
    def description: Optional[Description]
    def connectorProvisioningType
        : Optional[zio.aws.appflow.model.ConnectorProvisioningType]
    def connectorProvisioningConfig
        : Optional[zio.aws.appflow.model.ConnectorProvisioningConfig.ReadOnly]
    def getConnectorLabel: ZIO[Any, AwsError, ConnectorLabel] =
      AwsError.unwrapOptionField("connectorLabel", connectorLabel)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getConnectorProvisioningType
        : ZIO[Any, AwsError, zio.aws.appflow.model.ConnectorProvisioningType] =
      AwsError.unwrapOptionField(
        "connectorProvisioningType",
        connectorProvisioningType
      )
    def getConnectorProvisioningConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ConnectorProvisioningConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "connectorProvisioningConfig",
      connectorProvisioningConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.RegisterConnectorRequest
  ) extends zio.aws.appflow.model.RegisterConnectorRequest.ReadOnly {
    override val connectorLabel: Optional[ConnectorLabel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorLabel())
        .map(value => zio.aws.appflow.model.primitives.ConnectorLabel(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appflow.model.primitives.Description(value))
    override val connectorProvisioningType
        : Optional[zio.aws.appflow.model.ConnectorProvisioningType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorProvisioningType())
        .map(value =>
          zio.aws.appflow.model.ConnectorProvisioningType.wrap(value)
        )
    override val connectorProvisioningConfig
        : Optional[zio.aws.appflow.model.ConnectorProvisioningConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorProvisioningConfig())
        .map(value =>
          zio.aws.appflow.model.ConnectorProvisioningConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.RegisterConnectorRequest
  ): zio.aws.appflow.model.RegisterConnectorRequest.ReadOnly = new Wrapper(impl)
}
