package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.ARN
import scala.jdk.CollectionConverters._
final case class RegisterConnectorResponse(
    connectorArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.RegisterConnectorResponse = {
    import RegisterConnectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.RegisterConnectorResponse
      .builder()
      .optionallyWith(
        connectorArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.connectorArn)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.RegisterConnectorResponse.ReadOnly =
    zio.aws.appflow.model.RegisterConnectorResponse.wrap(buildAwsValue())
}
object RegisterConnectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.RegisterConnectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.RegisterConnectorResponse =
      zio.aws.appflow.model
        .RegisterConnectorResponse(connectorArn.map(value => value))
    def connectorArn: Optional[ARN]
    def getConnectorArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("connectorArn", connectorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.RegisterConnectorResponse
  ) extends zio.aws.appflow.model.RegisterConnectorResponse.ReadOnly {
    override val connectorArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorArn())
      .map(value => zio.aws.appflow.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.RegisterConnectorResponse
  ): zio.aws.appflow.model.RegisterConnectorResponse.ReadOnly = new Wrapper(
    impl
  )
}
