package zio.aws.appflow.model
import scala.jdk.CollectionConverters._
sealed trait S3InputFileType {
  def unwrap: software.amazon.awssdk.services.appflow.model.S3InputFileType
}
object S3InputFileType {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.S3InputFileType
  ): zio.aws.appflow.model.S3InputFileType = value match {
    case software.amazon.awssdk.services.appflow.model.S3InputFileType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.S3InputFileType.CSV =>
      val r = CSV
      r
    case software.amazon.awssdk.services.appflow.model.S3InputFileType.JSON =>
      val r = JSON
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appflow.model.S3InputFileType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.S3InputFileType =
      software.amazon.awssdk.services.appflow.model.S3InputFileType.UNKNOWN_TO_SDK_VERSION
  }
  case object CSV extends zio.aws.appflow.model.S3InputFileType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.S3InputFileType =
      software.amazon.awssdk.services.appflow.model.S3InputFileType.CSV
  }
  case object JSON extends zio.aws.appflow.model.S3InputFileType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.S3InputFileType =
      software.amazon.awssdk.services.appflow.model.S3InputFileType.JSON
  }
}
