package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3InputFormatConfig(
    s3InputFileType: Optional[zio.aws.appflow.model.S3InputFileType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.S3InputFormatConfig = {
    import S3InputFormatConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.S3InputFormatConfig
      .builder()
      .optionallyWith(s3InputFileType.map(value => value.unwrap))(
        _.s3InputFileType
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.S3InputFormatConfig.ReadOnly =
    zio.aws.appflow.model.S3InputFormatConfig.wrap(buildAwsValue())
}
object S3InputFormatConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.S3InputFormatConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.S3InputFormatConfig =
      zio.aws.appflow.model
        .S3InputFormatConfig(s3InputFileType.map(value => value))
    def s3InputFileType: Optional[zio.aws.appflow.model.S3InputFileType]
    def getS3InputFileType
        : ZIO[Any, AwsError, zio.aws.appflow.model.S3InputFileType] =
      AwsError.unwrapOptionField("s3InputFileType", s3InputFileType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.S3InputFormatConfig
  ) extends zio.aws.appflow.model.S3InputFormatConfig.ReadOnly {
    override val s3InputFileType
        : Optional[zio.aws.appflow.model.S3InputFileType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3InputFileType())
        .map(value => zio.aws.appflow.model.S3InputFileType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.S3InputFormatConfig
  ): zio.aws.appflow.model.S3InputFormatConfig.ReadOnly = new Wrapper(impl)
}
