package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.JavaBoolean
import scala.jdk.CollectionConverters._
final case class S3OutputFormatConfig(
    fileType: Optional[zio.aws.appflow.model.FileType] = Optional.Absent,
    prefixConfig: Optional[zio.aws.appflow.model.PrefixConfig] =
      Optional.Absent,
    aggregationConfig: Optional[zio.aws.appflow.model.AggregationConfig] =
      Optional.Absent,
    preserveSourceDataTyping: Optional[JavaBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.S3OutputFormatConfig = {
    import S3OutputFormatConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.S3OutputFormatConfig
      .builder()
      .optionallyWith(fileType.map(value => value.unwrap))(_.fileType)
      .optionallyWith(prefixConfig.map(value => value.buildAwsValue()))(
        _.prefixConfig
      )
      .optionallyWith(aggregationConfig.map(value => value.buildAwsValue()))(
        _.aggregationConfig
      )
      .optionallyWith(
        preserveSourceDataTyping.map(value =>
          JavaBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.preserveSourceDataTyping)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.S3OutputFormatConfig.ReadOnly =
    zio.aws.appflow.model.S3OutputFormatConfig.wrap(buildAwsValue())
}
object S3OutputFormatConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.S3OutputFormatConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.S3OutputFormatConfig =
      zio.aws.appflow.model.S3OutputFormatConfig(
        fileType.map(value => value),
        prefixConfig.map(value => value.asEditable),
        aggregationConfig.map(value => value.asEditable),
        preserveSourceDataTyping.map(value => value)
      )
    def fileType: Optional[zio.aws.appflow.model.FileType]
    def prefixConfig: Optional[zio.aws.appflow.model.PrefixConfig.ReadOnly]
    def aggregationConfig
        : Optional[zio.aws.appflow.model.AggregationConfig.ReadOnly]
    def preserveSourceDataTyping: Optional[JavaBoolean]
    def getFileType: ZIO[Any, AwsError, zio.aws.appflow.model.FileType] =
      AwsError.unwrapOptionField("fileType", fileType)
    def getPrefixConfig
        : ZIO[Any, AwsError, zio.aws.appflow.model.PrefixConfig.ReadOnly] =
      AwsError.unwrapOptionField("prefixConfig", prefixConfig)
    def getAggregationConfig
        : ZIO[Any, AwsError, zio.aws.appflow.model.AggregationConfig.ReadOnly] =
      AwsError.unwrapOptionField("aggregationConfig", aggregationConfig)
    def getPreserveSourceDataTyping: ZIO[Any, AwsError, JavaBoolean] = AwsError
      .unwrapOptionField("preserveSourceDataTyping", preserveSourceDataTyping)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.S3OutputFormatConfig
  ) extends zio.aws.appflow.model.S3OutputFormatConfig.ReadOnly {
    override val fileType: Optional[zio.aws.appflow.model.FileType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileType())
        .map(value => zio.aws.appflow.model.FileType.wrap(value))
    override val prefixConfig
        : Optional[zio.aws.appflow.model.PrefixConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixConfig())
        .map(value => zio.aws.appflow.model.PrefixConfig.wrap(value))
    override val aggregationConfig
        : Optional[zio.aws.appflow.model.AggregationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregationConfig())
        .map(value => zio.aws.appflow.model.AggregationConfig.wrap(value))
    override val preserveSourceDataTyping: Optional[JavaBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preserveSourceDataTyping())
        .map(value => zio.aws.appflow.model.primitives.JavaBoolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.S3OutputFormatConfig
  ): zio.aws.appflow.model.S3OutputFormatConfig.ReadOnly = new Wrapper(impl)
}
