package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{BucketPrefix, BucketName}
import scala.jdk.CollectionConverters._
final case class S3SourceProperties(
    bucketName: BucketName,
    bucketPrefix: Optional[BucketPrefix] = Optional.Absent,
    s3InputFormatConfig: Optional[zio.aws.appflow.model.S3InputFormatConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.S3SourceProperties = {
    import S3SourceProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.S3SourceProperties
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        bucketPrefix.map(value => BucketPrefix.unwrap(value): java.lang.String)
      )(_.bucketPrefix)
      .optionallyWith(s3InputFormatConfig.map(value => value.buildAwsValue()))(
        _.s3InputFormatConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.S3SourceProperties.ReadOnly =
    zio.aws.appflow.model.S3SourceProperties.wrap(buildAwsValue())
}
object S3SourceProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.S3SourceProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.S3SourceProperties =
      zio.aws.appflow.model.S3SourceProperties(
        bucketName,
        bucketPrefix.map(value => value),
        s3InputFormatConfig.map(value => value.asEditable)
      )
    def bucketName: BucketName
    def bucketPrefix: Optional[BucketPrefix]
    def s3InputFormatConfig
        : Optional[zio.aws.appflow.model.S3InputFormatConfig.ReadOnly]
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getBucketPrefix: ZIO[Any, AwsError, BucketPrefix] =
      AwsError.unwrapOptionField("bucketPrefix", bucketPrefix)
    def getS3InputFormatConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.S3InputFormatConfig.ReadOnly
    ] = AwsError.unwrapOptionField("s3InputFormatConfig", s3InputFormatConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.S3SourceProperties
  ) extends zio.aws.appflow.model.S3SourceProperties.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.appflow.model.primitives.BucketName(impl.bucketName())
    override val bucketPrefix: Optional[BucketPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketPrefix())
      .map(value => zio.aws.appflow.model.primitives.BucketPrefix(value))
    override val s3InputFormatConfig
        : Optional[zio.aws.appflow.model.S3InputFormatConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3InputFormatConfig())
        .map(value => zio.aws.appflow.model.S3InputFormatConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.S3SourceProperties
  ): zio.aws.appflow.model.S3SourceProperties.ReadOnly = new Wrapper(impl)
}
