package zio.aws.appflow.model
import zio.aws.appflow.model.primitives.{
  ApplicationServicePath,
  PortNumber,
  ClientNumber,
  PrivateLinkServiceName,
  ApplicationHostUrl,
  LogonLanguage
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SAPODataConnectorProfileProperties(
    applicationHostUrl: ApplicationHostUrl,
    applicationServicePath: ApplicationServicePath,
    portNumber: PortNumber,
    clientNumber: ClientNumber,
    logonLanguage: Optional[LogonLanguage] = Optional.Absent,
    privateLinkServiceName: Optional[PrivateLinkServiceName] = Optional.Absent,
    oAuthProperties: Optional[zio.aws.appflow.model.OAuthProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SAPODataConnectorProfileProperties = {
    import SAPODataConnectorProfileProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SAPODataConnectorProfileProperties
      .builder()
      .applicationHostUrl(
        ApplicationHostUrl.unwrap(applicationHostUrl): java.lang.String
      )
      .applicationServicePath(
        ApplicationServicePath.unwrap(applicationServicePath): java.lang.String
      )
      .portNumber(PortNumber.unwrap(portNumber): Integer)
      .clientNumber(ClientNumber.unwrap(clientNumber): java.lang.String)
      .optionallyWith(
        logonLanguage.map(value =>
          LogonLanguage.unwrap(value): java.lang.String
        )
      )(_.logonLanguage)
      .optionallyWith(
        privateLinkServiceName.map(value =>
          PrivateLinkServiceName.unwrap(value): java.lang.String
        )
      )(_.privateLinkServiceName)
      .optionallyWith(oAuthProperties.map(value => value.buildAwsValue()))(
        _.oAuthProperties
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.SAPODataConnectorProfileProperties.ReadOnly =
    zio.aws.appflow.model.SAPODataConnectorProfileProperties
      .wrap(buildAwsValue())
}
object SAPODataConnectorProfileProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SAPODataConnectorProfileProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.SAPODataConnectorProfileProperties =
      zio.aws.appflow.model.SAPODataConnectorProfileProperties(
        applicationHostUrl,
        applicationServicePath,
        portNumber,
        clientNumber,
        logonLanguage.map(value => value),
        privateLinkServiceName.map(value => value),
        oAuthProperties.map(value => value.asEditable)
      )
    def applicationHostUrl: ApplicationHostUrl
    def applicationServicePath: ApplicationServicePath
    def portNumber: PortNumber
    def clientNumber: ClientNumber
    def logonLanguage: Optional[LogonLanguage]
    def privateLinkServiceName: Optional[PrivateLinkServiceName]
    def oAuthProperties
        : Optional[zio.aws.appflow.model.OAuthProperties.ReadOnly]
    def getApplicationHostUrl: ZIO[Any, Nothing, ApplicationHostUrl] =
      ZIO.succeed(applicationHostUrl)
    def getApplicationServicePath: ZIO[Any, Nothing, ApplicationServicePath] =
      ZIO.succeed(applicationServicePath)
    def getPortNumber: ZIO[Any, Nothing, PortNumber] = ZIO.succeed(portNumber)
    def getClientNumber: ZIO[Any, Nothing, ClientNumber] =
      ZIO.succeed(clientNumber)
    def getLogonLanguage: ZIO[Any, AwsError, LogonLanguage] =
      AwsError.unwrapOptionField("logonLanguage", logonLanguage)
    def getPrivateLinkServiceName: ZIO[Any, AwsError, PrivateLinkServiceName] =
      AwsError.unwrapOptionField(
        "privateLinkServiceName",
        privateLinkServiceName
      )
    def getOAuthProperties
        : ZIO[Any, AwsError, zio.aws.appflow.model.OAuthProperties.ReadOnly] =
      AwsError.unwrapOptionField("oAuthProperties", oAuthProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SAPODataConnectorProfileProperties
  ) extends zio.aws.appflow.model.SAPODataConnectorProfileProperties.ReadOnly {
    override val applicationHostUrl: ApplicationHostUrl =
      zio.aws.appflow.model.primitives
        .ApplicationHostUrl(impl.applicationHostUrl())
    override val applicationServicePath: ApplicationServicePath =
      zio.aws.appflow.model.primitives
        .ApplicationServicePath(impl.applicationServicePath())
    override val portNumber: PortNumber =
      zio.aws.appflow.model.primitives.PortNumber(impl.portNumber())
    override val clientNumber: ClientNumber =
      zio.aws.appflow.model.primitives.ClientNumber(impl.clientNumber())
    override val logonLanguage: Optional[LogonLanguage] = zio.aws.core.internal
      .optionalFromNullable(impl.logonLanguage())
      .map(value => zio.aws.appflow.model.primitives.LogonLanguage(value))
    override val privateLinkServiceName: Optional[PrivateLinkServiceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateLinkServiceName())
        .map(value =>
          zio.aws.appflow.model.primitives.PrivateLinkServiceName(value)
        )
    override val oAuthProperties
        : Optional[zio.aws.appflow.model.OAuthProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oAuthProperties())
        .map(value => zio.aws.appflow.model.OAuthProperties.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SAPODataConnectorProfileProperties
  ): zio.aws.appflow.model.SAPODataConnectorProfileProperties.ReadOnly =
    new Wrapper(impl)
}
