package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.Object
import scala.jdk.CollectionConverters._
final case class SAPODataSourceProperties(
    objectPath: Optional[Object] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SAPODataSourceProperties = {
    import SAPODataSourceProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SAPODataSourceProperties
      .builder()
      .optionallyWith(
        objectPath.map(value => Object.unwrap(value): java.lang.String)
      )(_.objectPath)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.SAPODataSourceProperties.ReadOnly =
    zio.aws.appflow.model.SAPODataSourceProperties.wrap(buildAwsValue())
}
object SAPODataSourceProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SAPODataSourceProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.SAPODataSourceProperties =
      zio.aws.appflow.model
        .SAPODataSourceProperties(objectPath.map(value => value))
    def objectPath: Optional[Object]
    def getObjectPath: ZIO[Any, AwsError, Object] =
      AwsError.unwrapOptionField("objectPath", objectPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SAPODataSourceProperties
  ) extends zio.aws.appflow.model.SAPODataSourceProperties.ReadOnly {
    override val objectPath: Optional[Object] = zio.aws.core.internal
      .optionalFromNullable(impl.objectPath())
      .map(value => zio.aws.appflow.model.primitives.Object(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SAPODataSourceProperties
  ): zio.aws.appflow.model.SAPODataSourceProperties.ReadOnly = new Wrapper(impl)
}
