package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{
  ClientCredentialsArn,
  RefreshToken,
  AccessToken
}
import scala.jdk.CollectionConverters._
final case class SalesforceConnectorProfileCredentials(
    accessToken: Optional[AccessToken] = Optional.Absent,
    refreshToken: Optional[RefreshToken] = Optional.Absent,
    oAuthRequest: Optional[zio.aws.appflow.model.ConnectorOAuthRequest] =
      Optional.Absent,
    clientCredentialsArn: Optional[ClientCredentialsArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SalesforceConnectorProfileCredentials = {
    import SalesforceConnectorProfileCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SalesforceConnectorProfileCredentials
      .builder()
      .optionallyWith(
        accessToken.map(value => AccessToken.unwrap(value): java.lang.String)
      )(_.accessToken)
      .optionallyWith(
        refreshToken.map(value => RefreshToken.unwrap(value): java.lang.String)
      )(_.refreshToken)
      .optionallyWith(oAuthRequest.map(value => value.buildAwsValue()))(
        _.oAuthRequest
      )
      .optionallyWith(
        clientCredentialsArn.map(value =>
          ClientCredentialsArn.unwrap(value): java.lang.String
        )
      )(_.clientCredentialsArn)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.SalesforceConnectorProfileCredentials.ReadOnly =
    zio.aws.appflow.model.SalesforceConnectorProfileCredentials
      .wrap(buildAwsValue())
}
object SalesforceConnectorProfileCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SalesforceConnectorProfileCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appflow.model.SalesforceConnectorProfileCredentials =
      zio.aws.appflow.model.SalesforceConnectorProfileCredentials(
        accessToken.map(value => value),
        refreshToken.map(value => value),
        oAuthRequest.map(value => value.asEditable),
        clientCredentialsArn.map(value => value)
      )
    def accessToken: Optional[AccessToken]
    def refreshToken: Optional[RefreshToken]
    def oAuthRequest
        : Optional[zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly]
    def clientCredentialsArn: Optional[ClientCredentialsArn]
    def getAccessToken: ZIO[Any, AwsError, AccessToken] =
      AwsError.unwrapOptionField("accessToken", accessToken)
    def getRefreshToken: ZIO[Any, AwsError, RefreshToken] =
      AwsError.unwrapOptionField("refreshToken", refreshToken)
    def getOAuthRequest: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly
    ] = AwsError.unwrapOptionField("oAuthRequest", oAuthRequest)
    def getClientCredentialsArn: ZIO[Any, AwsError, ClientCredentialsArn] =
      AwsError.unwrapOptionField("clientCredentialsArn", clientCredentialsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SalesforceConnectorProfileCredentials
  ) extends zio.aws.appflow.model.SalesforceConnectorProfileCredentials.ReadOnly {
    override val accessToken: Optional[AccessToken] = zio.aws.core.internal
      .optionalFromNullable(impl.accessToken())
      .map(value => zio.aws.appflow.model.primitives.AccessToken(value))
    override val refreshToken: Optional[RefreshToken] = zio.aws.core.internal
      .optionalFromNullable(impl.refreshToken())
      .map(value => zio.aws.appflow.model.primitives.RefreshToken(value))
    override val oAuthRequest
        : Optional[zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oAuthRequest())
        .map(value => zio.aws.appflow.model.ConnectorOAuthRequest.wrap(value))
    override val clientCredentialsArn: Optional[ClientCredentialsArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientCredentialsArn())
        .map(value =>
          zio.aws.appflow.model.primitives.ClientCredentialsArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SalesforceConnectorProfileCredentials
  ): zio.aws.appflow.model.SalesforceConnectorProfileCredentials.ReadOnly =
    new Wrapper(impl)
}
