package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.InstanceUrl
import scala.jdk.CollectionConverters._
final case class SalesforceConnectorProfileProperties(
    instanceUrl: Optional[InstanceUrl] = Optional.Absent,
    isSandboxEnvironment: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SalesforceConnectorProfileProperties = {
    import SalesforceConnectorProfileProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SalesforceConnectorProfileProperties
      .builder()
      .optionallyWith(
        instanceUrl.map(value => InstanceUrl.unwrap(value): java.lang.String)
      )(_.instanceUrl)
      .optionallyWith(
        isSandboxEnvironment.map(value => value: java.lang.Boolean)
      )(_.isSandboxEnvironment)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.SalesforceConnectorProfileProperties.ReadOnly =
    zio.aws.appflow.model.SalesforceConnectorProfileProperties
      .wrap(buildAwsValue())
}
object SalesforceConnectorProfileProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SalesforceConnectorProfileProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.SalesforceConnectorProfileProperties =
      zio.aws.appflow.model.SalesforceConnectorProfileProperties(
        instanceUrl.map(value => value),
        isSandboxEnvironment.map(value => value)
      )
    def instanceUrl: Optional[InstanceUrl]
    def isSandboxEnvironment: Optional[Boolean]
    def getInstanceUrl: ZIO[Any, AwsError, InstanceUrl] =
      AwsError.unwrapOptionField("instanceUrl", instanceUrl)
    def getIsSandboxEnvironment: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSandboxEnvironment", isSandboxEnvironment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SalesforceConnectorProfileProperties
  ) extends zio.aws.appflow.model.SalesforceConnectorProfileProperties.ReadOnly {
    override val instanceUrl: Optional[InstanceUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceUrl())
      .map(value => zio.aws.appflow.model.primitives.InstanceUrl(value))
    override val isSandboxEnvironment: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isSandboxEnvironment())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SalesforceConnectorProfileProperties
  ): zio.aws.appflow.model.SalesforceConnectorProfileProperties.ReadOnly =
    new Wrapper(impl)
}
