package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.Object
import scala.jdk.CollectionConverters._
final case class SalesforceSourceProperties(
    `object`: Object,
    enableDynamicFieldUpdate: Optional[Boolean] = Optional.Absent,
    includeDeletedRecords: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SalesforceSourceProperties = {
    import SalesforceSourceProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SalesforceSourceProperties
      .builder()
      .`object`(Object.unwrap(`object`): java.lang.String)
      .optionallyWith(
        enableDynamicFieldUpdate.map(value => value: java.lang.Boolean)
      )(_.enableDynamicFieldUpdate)
      .optionallyWith(
        includeDeletedRecords.map(value => value: java.lang.Boolean)
      )(_.includeDeletedRecords)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.SalesforceSourceProperties.ReadOnly =
    zio.aws.appflow.model.SalesforceSourceProperties.wrap(buildAwsValue())
}
object SalesforceSourceProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SalesforceSourceProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.SalesforceSourceProperties =
      zio.aws.appflow.model.SalesforceSourceProperties(
        `object`,
        enableDynamicFieldUpdate.map(value => value),
        includeDeletedRecords.map(value => value)
      )
    def `object`: Object
    def enableDynamicFieldUpdate: Optional[Boolean]
    def includeDeletedRecords: Optional[Boolean]
    def getObject: ZIO[Any, Nothing, Object] = ZIO.succeed(`object`)
    def getEnableDynamicFieldUpdate: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableDynamicFieldUpdate", enableDynamicFieldUpdate)
    def getIncludeDeletedRecords: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeDeletedRecords", includeDeletedRecords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SalesforceSourceProperties
  ) extends zio.aws.appflow.model.SalesforceSourceProperties.ReadOnly {
    override val `object`: Object =
      zio.aws.appflow.model.primitives.Object(impl.`object`())
    override val enableDynamicFieldUpdate: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableDynamicFieldUpdate())
        .map(value => value: Boolean)
    override val includeDeletedRecords: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeDeletedRecords())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SalesforceSourceProperties
  ): zio.aws.appflow.model.SalesforceSourceProperties.ReadOnly = new Wrapper(
    impl
  )
}
