package zio.aws.appflow.model
import zio.aws.appflow.model.primitives.{
  Date,
  ScheduleExpression,
  ScheduleOffset,
  FlowErrorDeactivationThreshold,
  Timezone
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ScheduledTriggerProperties(
    scheduleExpression: ScheduleExpression,
    dataPullMode: Optional[zio.aws.appflow.model.DataPullMode] =
      Optional.Absent,
    scheduleStartTime: Optional[Date] = Optional.Absent,
    scheduleEndTime: Optional[Date] = Optional.Absent,
    timezone: Optional[Timezone] = Optional.Absent,
    scheduleOffset: Optional[ScheduleOffset] = Optional.Absent,
    firstExecutionFrom: Optional[Date] = Optional.Absent,
    flowErrorDeactivationThreshold: Optional[FlowErrorDeactivationThreshold] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ScheduledTriggerProperties = {
    import ScheduledTriggerProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ScheduledTriggerProperties
      .builder()
      .scheduleExpression(
        ScheduleExpression.unwrap(scheduleExpression): java.lang.String
      )
      .optionallyWith(dataPullMode.map(value => value.unwrap))(_.dataPullMode)
      .optionallyWith(
        scheduleStartTime.map(value => Date.unwrap(value): Instant)
      )(_.scheduleStartTime)
      .optionallyWith(
        scheduleEndTime.map(value => Date.unwrap(value): Instant)
      )(_.scheduleEndTime)
      .optionallyWith(
        timezone.map(value => Timezone.unwrap(value): java.lang.String)
      )(_.timezone)
      .optionallyWith(
        scheduleOffset.map(value =>
          ScheduleOffset.unwrap(value): java.lang.Long
        )
      )(_.scheduleOffset)
      .optionallyWith(
        firstExecutionFrom.map(value => Date.unwrap(value): Instant)
      )(_.firstExecutionFrom)
      .optionallyWith(
        flowErrorDeactivationThreshold.map(value =>
          FlowErrorDeactivationThreshold.unwrap(value): Integer
        )
      )(_.flowErrorDeactivationThreshold)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ScheduledTriggerProperties.ReadOnly =
    zio.aws.appflow.model.ScheduledTriggerProperties.wrap(buildAwsValue())
}
object ScheduledTriggerProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ScheduledTriggerProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ScheduledTriggerProperties =
      zio.aws.appflow.model.ScheduledTriggerProperties(
        scheduleExpression,
        dataPullMode.map(value => value),
        scheduleStartTime.map(value => value),
        scheduleEndTime.map(value => value),
        timezone.map(value => value),
        scheduleOffset.map(value => value),
        firstExecutionFrom.map(value => value),
        flowErrorDeactivationThreshold.map(value => value)
      )
    def scheduleExpression: ScheduleExpression
    def dataPullMode: Optional[zio.aws.appflow.model.DataPullMode]
    def scheduleStartTime: Optional[Date]
    def scheduleEndTime: Optional[Date]
    def timezone: Optional[Timezone]
    def scheduleOffset: Optional[ScheduleOffset]
    def firstExecutionFrom: Optional[Date]
    def flowErrorDeactivationThreshold: Optional[FlowErrorDeactivationThreshold]
    def getScheduleExpression: ZIO[Any, Nothing, ScheduleExpression] =
      ZIO.succeed(scheduleExpression)
    def getDataPullMode
        : ZIO[Any, AwsError, zio.aws.appflow.model.DataPullMode] =
      AwsError.unwrapOptionField("dataPullMode", dataPullMode)
    def getScheduleStartTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("scheduleStartTime", scheduleStartTime)
    def getScheduleEndTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("scheduleEndTime", scheduleEndTime)
    def getTimezone: ZIO[Any, AwsError, Timezone] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getScheduleOffset: ZIO[Any, AwsError, ScheduleOffset] =
      AwsError.unwrapOptionField("scheduleOffset", scheduleOffset)
    def getFirstExecutionFrom: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("firstExecutionFrom", firstExecutionFrom)
    def getFlowErrorDeactivationThreshold
        : ZIO[Any, AwsError, FlowErrorDeactivationThreshold] =
      AwsError.unwrapOptionField(
        "flowErrorDeactivationThreshold",
        flowErrorDeactivationThreshold
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ScheduledTriggerProperties
  ) extends zio.aws.appflow.model.ScheduledTriggerProperties.ReadOnly {
    override val scheduleExpression: ScheduleExpression =
      zio.aws.appflow.model.primitives
        .ScheduleExpression(impl.scheduleExpression())
    override val dataPullMode: Optional[zio.aws.appflow.model.DataPullMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataPullMode())
        .map(value => zio.aws.appflow.model.DataPullMode.wrap(value))
    override val scheduleStartTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleStartTime())
      .map(value => zio.aws.appflow.model.primitives.Date(value))
    override val scheduleEndTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleEndTime())
      .map(value => zio.aws.appflow.model.primitives.Date(value))
    override val timezone: Optional[Timezone] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value => zio.aws.appflow.model.primitives.Timezone(value))
    override val scheduleOffset: Optional[ScheduleOffset] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleOffset())
        .map(value => zio.aws.appflow.model.primitives.ScheduleOffset(value))
    override val firstExecutionFrom: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.firstExecutionFrom())
      .map(value => zio.aws.appflow.model.primitives.Date(value))
    override val flowErrorDeactivationThreshold
        : Optional[FlowErrorDeactivationThreshold] = zio.aws.core.internal
      .optionalFromNullable(impl.flowErrorDeactivationThreshold())
      .map(value =>
        zio.aws.appflow.model.primitives.FlowErrorDeactivationThreshold(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ScheduledTriggerProperties
  ): zio.aws.appflow.model.ScheduledTriggerProperties.ReadOnly = new Wrapper(
    impl
  )
}
