package zio.aws.appflow.model
import scala.jdk.CollectionConverters._
sealed trait SlackConnectorOperator {
  def unwrap
      : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator
}
object SlackConnectorOperator {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.SlackConnectorOperator
  ): zio.aws.appflow.model.SlackConnectorOperator = value match {
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.PROJECTION =>
      val r = PROJECTION
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.LESS_THAN =>
      val r = LESS_THAN
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.GREATER_THAN =>
      val r = GREATER_THAN
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.BETWEEN =>
      val r = BETWEEN
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.LESS_THAN_OR_EQUAL_TO =>
      val r = LESS_THAN_OR_EQUAL_TO
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.GREATER_THAN_OR_EQUAL_TO =>
      val r = GREATER_THAN_OR_EQUAL_TO
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.EQUAL_TO =>
      val r = EQUAL_TO
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.ADDITION =>
      val r = ADDITION
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.MULTIPLICATION =>
      val r = MULTIPLICATION
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.DIVISION =>
      val r = DIVISION
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.SUBTRACTION =>
      val r = SUBTRACTION
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.MASK_ALL =>
      val r = MASK_ALL
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.MASK_FIRST_N =>
      val r = MASK_FIRST_N
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.MASK_LAST_N =>
      val r = MASK_LAST_N
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.VALIDATE_NON_NULL =>
      val r = VALIDATE_NON_NULL
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.VALIDATE_NON_ZERO =>
      val r = VALIDATE_NON_ZERO
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.VALIDATE_NON_NEGATIVE =>
      val r = VALIDATE_NON_NEGATIVE
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.VALIDATE_NUMERIC =>
      val r = VALIDATE_NUMERIC
      r
    case software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.NO_OP =>
      val r = NO_OP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object PROJECTION extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.PROJECTION
  }
  case object LESS_THAN extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.LESS_THAN
  }
  case object GREATER_THAN
      extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.GREATER_THAN
  }
  case object BETWEEN extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.BETWEEN
  }
  case object LESS_THAN_OR_EQUAL_TO
      extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.LESS_THAN_OR_EQUAL_TO
  }
  case object GREATER_THAN_OR_EQUAL_TO
      extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.GREATER_THAN_OR_EQUAL_TO
  }
  case object EQUAL_TO extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.EQUAL_TO
  }
  case object ADDITION extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.ADDITION
  }
  case object MULTIPLICATION
      extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.MULTIPLICATION
  }
  case object DIVISION extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.DIVISION
  }
  case object SUBTRACTION extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.SUBTRACTION
  }
  case object MASK_ALL extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.MASK_ALL
  }
  case object MASK_FIRST_N
      extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.MASK_FIRST_N
  }
  case object MASK_LAST_N extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.MASK_LAST_N
  }
  case object VALIDATE_NON_NULL
      extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.VALIDATE_NON_NULL
  }
  case object VALIDATE_NON_ZERO
      extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.VALIDATE_NON_ZERO
  }
  case object VALIDATE_NON_NEGATIVE
      extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.VALIDATE_NON_NEGATIVE
  }
  case object VALIDATE_NUMERIC
      extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.VALIDATE_NUMERIC
  }
  case object NO_OP extends zio.aws.appflow.model.SlackConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SlackConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SlackConnectorOperator.NO_OP
  }
}
