package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.InstanceUrl
import scala.jdk.CollectionConverters._
final case class SlackConnectorProfileProperties(instanceUrl: InstanceUrl) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SlackConnectorProfileProperties = {
    import SlackConnectorProfileProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SlackConnectorProfileProperties
      .builder()
      .instanceUrl(InstanceUrl.unwrap(instanceUrl): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.SlackConnectorProfileProperties.ReadOnly =
    zio.aws.appflow.model.SlackConnectorProfileProperties.wrap(buildAwsValue())
}
object SlackConnectorProfileProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SlackConnectorProfileProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.SlackConnectorProfileProperties =
      zio.aws.appflow.model.SlackConnectorProfileProperties(instanceUrl)
    def instanceUrl: InstanceUrl
    def getInstanceUrl: ZIO[Any, Nothing, InstanceUrl] =
      ZIO.succeed(instanceUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SlackConnectorProfileProperties
  ) extends zio.aws.appflow.model.SlackConnectorProfileProperties.ReadOnly {
    override val instanceUrl: InstanceUrl =
      zio.aws.appflow.model.primitives.InstanceUrl(impl.instanceUrl())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SlackConnectorProfileProperties
  ): zio.aws.appflow.model.SlackConnectorProfileProperties.ReadOnly =
    new Wrapper(impl)
}
