package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.{Password, Username}
import scala.jdk.CollectionConverters._
final case class SnowflakeConnectorProfileCredentials(
    username: Username,
    password: Password
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SnowflakeConnectorProfileCredentials = {
    import SnowflakeConnectorProfileCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SnowflakeConnectorProfileCredentials
      .builder()
      .username(Username.unwrap(username): java.lang.String)
      .password(Password.unwrap(password): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.SnowflakeConnectorProfileCredentials.ReadOnly =
    zio.aws.appflow.model.SnowflakeConnectorProfileCredentials
      .wrap(buildAwsValue())
}
object SnowflakeConnectorProfileCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SnowflakeConnectorProfileCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.SnowflakeConnectorProfileCredentials =
      zio.aws.appflow.model
        .SnowflakeConnectorProfileCredentials(username, password)
    def username: Username
    def password: Password
    def getUsername: ZIO[Any, Nothing, Username] = ZIO.succeed(username)
    def getPassword: ZIO[Any, Nothing, Password] = ZIO.succeed(password)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SnowflakeConnectorProfileCredentials
  ) extends zio.aws.appflow.model.SnowflakeConnectorProfileCredentials.ReadOnly {
    override val username: Username =
      zio.aws.appflow.model.primitives.Username(impl.username())
    override val password: Password =
      zio.aws.appflow.model.primitives.Password(impl.password())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SnowflakeConnectorProfileCredentials
  ): zio.aws.appflow.model.SnowflakeConnectorProfileCredentials.ReadOnly =
    new Wrapper(impl)
}
