package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.Region
import scala.jdk.CollectionConverters._
final case class SnowflakeMetadata(
    supportedRegions: Optional[Iterable[Region]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SnowflakeMetadata = {
    import SnowflakeMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SnowflakeMetadata
      .builder()
      .optionallyWith(
        supportedRegions.map(value =>
          value.map { item =>
            Region.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedRegions)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.SnowflakeMetadata.ReadOnly =
    zio.aws.appflow.model.SnowflakeMetadata.wrap(buildAwsValue())
}
object SnowflakeMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SnowflakeMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.SnowflakeMetadata =
      zio.aws.appflow.model
        .SnowflakeMetadata(supportedRegions.map(value => value))
    def supportedRegions: Optional[List[Region]]
    def getSupportedRegions: ZIO[Any, AwsError, List[Region]] =
      AwsError.unwrapOptionField("supportedRegions", supportedRegions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SnowflakeMetadata
  ) extends zio.aws.appflow.model.SnowflakeMetadata.ReadOnly {
    override val supportedRegions: Optional[List[Region]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedRegions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.primitives.Region(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SnowflakeMetadata
  ): zio.aws.appflow.model.SnowflakeMetadata.ReadOnly = new Wrapper(impl)
}
