package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{ExecutionId, FlowArn}
import scala.jdk.CollectionConverters._
final case class StartFlowResponse(
    flowArn: Optional[FlowArn] = Optional.Absent,
    flowStatus: Optional[zio.aws.appflow.model.FlowStatus] = Optional.Absent,
    executionId: Optional[ExecutionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.StartFlowResponse = {
    import StartFlowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.StartFlowResponse
      .builder()
      .optionallyWith(
        flowArn.map(value => FlowArn.unwrap(value): java.lang.String)
      )(_.flowArn)
      .optionallyWith(flowStatus.map(value => value.unwrap))(_.flowStatus)
      .optionallyWith(
        executionId.map(value => ExecutionId.unwrap(value): java.lang.String)
      )(_.executionId)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.StartFlowResponse.ReadOnly =
    zio.aws.appflow.model.StartFlowResponse.wrap(buildAwsValue())
}
object StartFlowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.StartFlowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.StartFlowResponse =
      zio.aws.appflow.model.StartFlowResponse(
        flowArn.map(value => value),
        flowStatus.map(value => value),
        executionId.map(value => value)
      )
    def flowArn: Optional[FlowArn]
    def flowStatus: Optional[zio.aws.appflow.model.FlowStatus]
    def executionId: Optional[ExecutionId]
    def getFlowArn: ZIO[Any, AwsError, FlowArn] =
      AwsError.unwrapOptionField("flowArn", flowArn)
    def getFlowStatus: ZIO[Any, AwsError, zio.aws.appflow.model.FlowStatus] =
      AwsError.unwrapOptionField("flowStatus", flowStatus)
    def getExecutionId: ZIO[Any, AwsError, ExecutionId] =
      AwsError.unwrapOptionField("executionId", executionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.StartFlowResponse
  ) extends zio.aws.appflow.model.StartFlowResponse.ReadOnly {
    override val flowArn: Optional[FlowArn] = zio.aws.core.internal
      .optionalFromNullable(impl.flowArn())
      .map(value => zio.aws.appflow.model.primitives.FlowArn(value))
    override val flowStatus: Optional[zio.aws.appflow.model.FlowStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flowStatus())
        .map(value => zio.aws.appflow.model.FlowStatus.wrap(value))
    override val executionId: Optional[ExecutionId] = zio.aws.core.internal
      .optionalFromNullable(impl.executionId())
      .map(value => zio.aws.appflow.model.primitives.ExecutionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.StartFlowResponse
  ): zio.aws.appflow.model.StartFlowResponse.ReadOnly = new Wrapper(impl)
}
