package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.FlowArn
import scala.jdk.CollectionConverters._
final case class StopFlowResponse(
    flowArn: Optional[FlowArn] = Optional.Absent,
    flowStatus: Optional[zio.aws.appflow.model.FlowStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.StopFlowResponse = {
    import StopFlowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.StopFlowResponse
      .builder()
      .optionallyWith(
        flowArn.map(value => FlowArn.unwrap(value): java.lang.String)
      )(_.flowArn)
      .optionallyWith(flowStatus.map(value => value.unwrap))(_.flowStatus)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.StopFlowResponse.ReadOnly =
    zio.aws.appflow.model.StopFlowResponse.wrap(buildAwsValue())
}
object StopFlowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.StopFlowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.StopFlowResponse =
      zio.aws.appflow.model.StopFlowResponse(
        flowArn.map(value => value),
        flowStatus.map(value => value)
      )
    def flowArn: Optional[FlowArn]
    def flowStatus: Optional[zio.aws.appflow.model.FlowStatus]
    def getFlowArn: ZIO[Any, AwsError, FlowArn] =
      AwsError.unwrapOptionField("flowArn", flowArn)
    def getFlowStatus: ZIO[Any, AwsError, zio.aws.appflow.model.FlowStatus] =
      AwsError.unwrapOptionField("flowStatus", flowStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.StopFlowResponse
  ) extends zio.aws.appflow.model.StopFlowResponse.ReadOnly {
    override val flowArn: Optional[FlowArn] = zio.aws.core.internal
      .optionalFromNullable(impl.flowArn())
      .map(value => zio.aws.appflow.model.primitives.FlowArn(value))
    override val flowStatus: Optional[zio.aws.appflow.model.FlowStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flowStatus())
        .map(value => zio.aws.appflow.model.FlowStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.StopFlowResponse
  ): zio.aws.appflow.model.StopFlowResponse.ReadOnly = new Wrapper(impl)
}
