package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{BucketName, BucketPrefix}
import scala.jdk.CollectionConverters._
final case class SuccessResponseHandlingConfig(
    bucketPrefix: Optional[BucketPrefix] = Optional.Absent,
    bucketName: Optional[BucketName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SuccessResponseHandlingConfig = {
    import SuccessResponseHandlingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SuccessResponseHandlingConfig
      .builder()
      .optionallyWith(
        bucketPrefix.map(value => BucketPrefix.unwrap(value): java.lang.String)
      )(_.bucketPrefix)
      .optionallyWith(
        bucketName.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucketName)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.SuccessResponseHandlingConfig.ReadOnly =
    zio.aws.appflow.model.SuccessResponseHandlingConfig.wrap(buildAwsValue())
}
object SuccessResponseHandlingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SuccessResponseHandlingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.SuccessResponseHandlingConfig =
      zio.aws.appflow.model.SuccessResponseHandlingConfig(
        bucketPrefix.map(value => value),
        bucketName.map(value => value)
      )
    def bucketPrefix: Optional[BucketPrefix]
    def bucketName: Optional[BucketName]
    def getBucketPrefix: ZIO[Any, AwsError, BucketPrefix] =
      AwsError.unwrapOptionField("bucketPrefix", bucketPrefix)
    def getBucketName: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucketName", bucketName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SuccessResponseHandlingConfig
  ) extends zio.aws.appflow.model.SuccessResponseHandlingConfig.ReadOnly {
    override val bucketPrefix: Optional[BucketPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketPrefix())
      .map(value => zio.aws.appflow.model.primitives.BucketPrefix(value))
    override val bucketName: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value => zio.aws.appflow.model.primitives.BucketName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SuccessResponseHandlingConfig
  ): zio.aws.appflow.model.SuccessResponseHandlingConfig.ReadOnly = new Wrapper(
    impl
  )
}
