package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{Property, DestinationField}
import scala.jdk.CollectionConverters._
final case class Task(
    sourceFields: Iterable[String],
    connectorOperator: Optional[zio.aws.appflow.model.ConnectorOperator] =
      Optional.Absent,
    destinationField: Optional[DestinationField] = Optional.Absent,
    taskType: zio.aws.appflow.model.TaskType,
    taskProperties: Optional[
      Map[zio.aws.appflow.model.OperatorPropertiesKeys, Property]
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.appflow.model.Task = {
    import Task.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.Task
      .builder()
      .sourceFields(sourceFields.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(connectorOperator.map(value => value.buildAwsValue()))(
        _.connectorOperator
      )
      .optionallyWith(
        destinationField.map(value =>
          DestinationField.unwrap(value): java.lang.String
        )
      )(_.destinationField)
      .taskType(taskType.unwrap)
      .optionallyWith(
        taskProperties.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (Property.unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.taskPropertiesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.Task.ReadOnly =
    zio.aws.appflow.model.Task.wrap(buildAwsValue())
}
object Task {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appflow.model.Task] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.Task = zio.aws.appflow.model.Task(
      sourceFields,
      connectorOperator.map(value => value.asEditable),
      destinationField.map(value => value),
      taskType,
      taskProperties.map(value => value)
    )
    def sourceFields: List[String]
    def connectorOperator
        : Optional[zio.aws.appflow.model.ConnectorOperator.ReadOnly]
    def destinationField: Optional[DestinationField]
    def taskType: zio.aws.appflow.model.TaskType
    def taskProperties
        : Optional[Map[zio.aws.appflow.model.OperatorPropertiesKeys, Property]]
    def getSourceFields: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(sourceFields)
    def getConnectorOperator
        : ZIO[Any, AwsError, zio.aws.appflow.model.ConnectorOperator.ReadOnly] =
      AwsError.unwrapOptionField("connectorOperator", connectorOperator)
    def getDestinationField: ZIO[Any, AwsError, DestinationField] =
      AwsError.unwrapOptionField("destinationField", destinationField)
    def getTaskType: ZIO[Any, Nothing, zio.aws.appflow.model.TaskType] =
      ZIO.succeed(taskType)
    def getTaskProperties: ZIO[Any, AwsError, Map[
      zio.aws.appflow.model.OperatorPropertiesKeys,
      Property
    ]] = AwsError.unwrapOptionField("taskProperties", taskProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.Task
  ) extends zio.aws.appflow.model.Task.ReadOnly {
    override val sourceFields: List[String] = impl
      .sourceFields()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val connectorOperator
        : Optional[zio.aws.appflow.model.ConnectorOperator.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorOperator())
        .map(value => zio.aws.appflow.model.ConnectorOperator.wrap(value))
    override val destinationField: Optional[DestinationField] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationField())
        .map(value => zio.aws.appflow.model.primitives.DestinationField(value))
    override val taskType: zio.aws.appflow.model.TaskType =
      zio.aws.appflow.model.TaskType.wrap(impl.taskType())
    override val taskProperties: Optional[
      Map[zio.aws.appflow.model.OperatorPropertiesKeys, Property]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.taskProperties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appflow.model.OperatorPropertiesKeys
              .wrap(key) -> zio.aws.appflow.model.primitives.Property(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.Task
  ): zio.aws.appflow.model.Task.ReadOnly = new Wrapper(impl)
}
