package zio.aws.appflow.model
import scala.jdk.CollectionConverters._
sealed trait TaskType {
  def unwrap: software.amazon.awssdk.services.appflow.model.TaskType
}
object TaskType {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.TaskType
  ): zio.aws.appflow.model.TaskType = value match {
    case software.amazon.awssdk.services.appflow.model.TaskType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.TaskType.ARITHMETIC =>
      val r = Arithmetic
      r
    case software.amazon.awssdk.services.appflow.model.TaskType.FILTER =>
      val r = Filter
      r
    case software.amazon.awssdk.services.appflow.model.TaskType.MAP =>
      val r = Map
      r
    case software.amazon.awssdk.services.appflow.model.TaskType.MAP_ALL =>
      val r = Map_all
      r
    case software.amazon.awssdk.services.appflow.model.TaskType.MASK =>
      val r = Mask
      r
    case software.amazon.awssdk.services.appflow.model.TaskType.MERGE =>
      val r = Merge
      r
    case software.amazon.awssdk.services.appflow.model.TaskType.PASSTHROUGH =>
      val r = Passthrough
      r
    case software.amazon.awssdk.services.appflow.model.TaskType.TRUNCATE =>
      val r = Truncate
      r
    case software.amazon.awssdk.services.appflow.model.TaskType.VALIDATE =>
      val r = Validate
      r
  }
  case object unknownToSdkVersion extends zio.aws.appflow.model.TaskType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.TaskType =
      software.amazon.awssdk.services.appflow.model.TaskType.UNKNOWN_TO_SDK_VERSION
  }
  case object Arithmetic extends zio.aws.appflow.model.TaskType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.TaskType =
      software.amazon.awssdk.services.appflow.model.TaskType.ARITHMETIC
  }
  case object Filter extends zio.aws.appflow.model.TaskType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.TaskType =
      software.amazon.awssdk.services.appflow.model.TaskType.FILTER
  }
  case object Map extends zio.aws.appflow.model.TaskType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.TaskType =
      software.amazon.awssdk.services.appflow.model.TaskType.MAP
  }
  case object Map_all extends zio.aws.appflow.model.TaskType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.TaskType =
      software.amazon.awssdk.services.appflow.model.TaskType.MAP_ALL
  }
  case object Mask extends zio.aws.appflow.model.TaskType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.TaskType =
      software.amazon.awssdk.services.appflow.model.TaskType.MASK
  }
  case object Merge extends zio.aws.appflow.model.TaskType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.TaskType =
      software.amazon.awssdk.services.appflow.model.TaskType.MERGE
  }
  case object Passthrough extends zio.aws.appflow.model.TaskType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.TaskType =
      software.amazon.awssdk.services.appflow.model.TaskType.PASSTHROUGH
  }
  case object Truncate extends zio.aws.appflow.model.TaskType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.TaskType =
      software.amazon.awssdk.services.appflow.model.TaskType.TRUNCATE
  }
  case object Validate extends zio.aws.appflow.model.TaskType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.TaskType =
      software.amazon.awssdk.services.appflow.model.TaskType.VALIDATE
  }
}
