package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.ApiSecretKey
import scala.jdk.CollectionConverters._
final case class TrendmicroConnectorProfileCredentials(
    apiSecretKey: ApiSecretKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.TrendmicroConnectorProfileCredentials = {
    import TrendmicroConnectorProfileCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.TrendmicroConnectorProfileCredentials
      .builder()
      .apiSecretKey(ApiSecretKey.unwrap(apiSecretKey): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.TrendmicroConnectorProfileCredentials.ReadOnly =
    zio.aws.appflow.model.TrendmicroConnectorProfileCredentials
      .wrap(buildAwsValue())
}
object TrendmicroConnectorProfileCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.TrendmicroConnectorProfileCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appflow.model.TrendmicroConnectorProfileCredentials =
      zio.aws.appflow.model.TrendmicroConnectorProfileCredentials(apiSecretKey)
    def apiSecretKey: ApiSecretKey
    def getApiSecretKey: ZIO[Any, Nothing, ApiSecretKey] =
      ZIO.succeed(apiSecretKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.TrendmicroConnectorProfileCredentials
  ) extends zio.aws.appflow.model.TrendmicroConnectorProfileCredentials.ReadOnly {
    override val apiSecretKey: ApiSecretKey =
      zio.aws.appflow.model.primitives.ApiSecretKey(impl.apiSecretKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.TrendmicroConnectorProfileCredentials
  ): zio.aws.appflow.model.TrendmicroConnectorProfileCredentials.ReadOnly =
    new Wrapper(impl)
}
