package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TriggerConfig(
    triggerType: zio.aws.appflow.model.TriggerType,
    triggerProperties: Optional[zio.aws.appflow.model.TriggerProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.TriggerConfig = {
    import TriggerConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.TriggerConfig
      .builder()
      .triggerType(triggerType.unwrap)
      .optionallyWith(triggerProperties.map(value => value.buildAwsValue()))(
        _.triggerProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.TriggerConfig.ReadOnly =
    zio.aws.appflow.model.TriggerConfig.wrap(buildAwsValue())
}
object TriggerConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.TriggerConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.TriggerConfig =
      zio.aws.appflow.model.TriggerConfig(
        triggerType,
        triggerProperties.map(value => value.asEditable)
      )
    def triggerType: zio.aws.appflow.model.TriggerType
    def triggerProperties
        : Optional[zio.aws.appflow.model.TriggerProperties.ReadOnly]
    def getTriggerType: ZIO[Any, Nothing, zio.aws.appflow.model.TriggerType] =
      ZIO.succeed(triggerType)
    def getTriggerProperties
        : ZIO[Any, AwsError, zio.aws.appflow.model.TriggerProperties.ReadOnly] =
      AwsError.unwrapOptionField("triggerProperties", triggerProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.TriggerConfig
  ) extends zio.aws.appflow.model.TriggerConfig.ReadOnly {
    override val triggerType: zio.aws.appflow.model.TriggerType =
      zio.aws.appflow.model.TriggerType.wrap(impl.triggerType())
    override val triggerProperties
        : Optional[zio.aws.appflow.model.TriggerProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.triggerProperties())
        .map(value => zio.aws.appflow.model.TriggerProperties.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.TriggerConfig
  ): zio.aws.appflow.model.TriggerConfig.ReadOnly = new Wrapper(impl)
}
