package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TriggerProperties(
    scheduled: Optional[zio.aws.appflow.model.ScheduledTriggerProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.TriggerProperties = {
    import TriggerProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.TriggerProperties
      .builder()
      .optionallyWith(scheduled.map(value => value.buildAwsValue()))(
        _.scheduled
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.TriggerProperties.ReadOnly =
    zio.aws.appflow.model.TriggerProperties.wrap(buildAwsValue())
}
object TriggerProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.TriggerProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.TriggerProperties =
      zio.aws.appflow.model
        .TriggerProperties(scheduled.map(value => value.asEditable))
    def scheduled
        : Optional[zio.aws.appflow.model.ScheduledTriggerProperties.ReadOnly]
    def getScheduled: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ScheduledTriggerProperties.ReadOnly
    ] = AwsError.unwrapOptionField("scheduled", scheduled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.TriggerProperties
  ) extends zio.aws.appflow.model.TriggerProperties.ReadOnly {
    override val scheduled
        : Optional[zio.aws.appflow.model.ScheduledTriggerProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduled())
        .map(value =>
          zio.aws.appflow.model.ScheduledTriggerProperties.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.TriggerProperties
  ): zio.aws.appflow.model.TriggerProperties.ReadOnly = new Wrapper(impl)
}
