package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.ConnectorProfileArn
import scala.jdk.CollectionConverters._
final case class UpdateConnectorProfileResponse(
    connectorProfileArn: Optional[ConnectorProfileArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileResponse = {
    import UpdateConnectorProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileResponse
      .builder()
      .optionallyWith(
        connectorProfileArn.map(value =>
          ConnectorProfileArn.unwrap(value): java.lang.String
        )
      )(_.connectorProfileArn)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.UpdateConnectorProfileResponse.ReadOnly =
    zio.aws.appflow.model.UpdateConnectorProfileResponse.wrap(buildAwsValue())
}
object UpdateConnectorProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.UpdateConnectorProfileResponse =
      zio.aws.appflow.model
        .UpdateConnectorProfileResponse(connectorProfileArn.map(value => value))
    def connectorProfileArn: Optional[ConnectorProfileArn]
    def getConnectorProfileArn: ZIO[Any, AwsError, ConnectorProfileArn] =
      AwsError.unwrapOptionField("connectorProfileArn", connectorProfileArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileResponse
  ) extends zio.aws.appflow.model.UpdateConnectorProfileResponse.ReadOnly {
    override val connectorProfileArn: Optional[ConnectorProfileArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorProfileArn())
        .map(value =>
          zio.aws.appflow.model.primitives.ConnectorProfileArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.UpdateConnectorProfileResponse
  ): zio.aws.appflow.model.UpdateConnectorProfileResponse.ReadOnly =
    new Wrapper(impl)
}
