package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{FlowDescription, FlowName}
import scala.jdk.CollectionConverters._
final case class UpdateFlowRequest(
    flowName: FlowName,
    description: Optional[FlowDescription] = Optional.Absent,
    triggerConfig: zio.aws.appflow.model.TriggerConfig,
    sourceFlowConfig: zio.aws.appflow.model.SourceFlowConfig,
    destinationFlowConfigList: Iterable[
      zio.aws.appflow.model.DestinationFlowConfig
    ],
    tasks: Iterable[zio.aws.appflow.model.Task]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.UpdateFlowRequest = {
    import UpdateFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.UpdateFlowRequest
      .builder()
      .flowName(FlowName.unwrap(flowName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          FlowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .triggerConfig(triggerConfig.buildAwsValue())
      .sourceFlowConfig(sourceFlowConfig.buildAwsValue())
      .destinationFlowConfigList(destinationFlowConfigList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .tasks(tasks.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.UpdateFlowRequest.ReadOnly =
    zio.aws.appflow.model.UpdateFlowRequest.wrap(buildAwsValue())
}
object UpdateFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.UpdateFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.UpdateFlowRequest =
      zio.aws.appflow.model.UpdateFlowRequest(
        flowName,
        description.map(value => value),
        triggerConfig.asEditable,
        sourceFlowConfig.asEditable,
        destinationFlowConfigList.map { item =>
          item.asEditable
        },
        tasks.map { item =>
          item.asEditable
        }
      )
    def flowName: FlowName
    def description: Optional[FlowDescription]
    def triggerConfig: zio.aws.appflow.model.TriggerConfig.ReadOnly
    def sourceFlowConfig: zio.aws.appflow.model.SourceFlowConfig.ReadOnly
    def destinationFlowConfigList
        : List[zio.aws.appflow.model.DestinationFlowConfig.ReadOnly]
    def tasks: List[zio.aws.appflow.model.Task.ReadOnly]
    def getFlowName: ZIO[Any, Nothing, FlowName] = ZIO.succeed(flowName)
    def getDescription: ZIO[Any, AwsError, FlowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTriggerConfig
        : ZIO[Any, Nothing, zio.aws.appflow.model.TriggerConfig.ReadOnly] =
      ZIO.succeed(triggerConfig)
    def getSourceFlowConfig
        : ZIO[Any, Nothing, zio.aws.appflow.model.SourceFlowConfig.ReadOnly] =
      ZIO.succeed(sourceFlowConfig)
    def getDestinationFlowConfigList: ZIO[Any, Nothing, List[
      zio.aws.appflow.model.DestinationFlowConfig.ReadOnly
    ]] = ZIO.succeed(destinationFlowConfigList)
    def getTasks: ZIO[Any, Nothing, List[zio.aws.appflow.model.Task.ReadOnly]] =
      ZIO.succeed(tasks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.UpdateFlowRequest
  ) extends zio.aws.appflow.model.UpdateFlowRequest.ReadOnly {
    override val flowName: FlowName =
      zio.aws.appflow.model.primitives.FlowName(impl.flowName())
    override val description: Optional[FlowDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appflow.model.primitives.FlowDescription(value))
    override val triggerConfig: zio.aws.appflow.model.TriggerConfig.ReadOnly =
      zio.aws.appflow.model.TriggerConfig.wrap(impl.triggerConfig())
    override val sourceFlowConfig
        : zio.aws.appflow.model.SourceFlowConfig.ReadOnly =
      zio.aws.appflow.model.SourceFlowConfig.wrap(impl.sourceFlowConfig())
    override val destinationFlowConfigList
        : List[zio.aws.appflow.model.DestinationFlowConfig.ReadOnly] = impl
      .destinationFlowConfigList()
      .asScala
      .map { item =>
        zio.aws.appflow.model.DestinationFlowConfig.wrap(item)
      }
      .toList
    override val tasks: List[zio.aws.appflow.model.Task.ReadOnly] = impl
      .tasks()
      .asScala
      .map { item =>
        zio.aws.appflow.model.Task.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.UpdateFlowRequest
  ): zio.aws.appflow.model.UpdateFlowRequest.ReadOnly = new Wrapper(impl)
}
