package zio.aws.appflow.model
import scala.jdk.CollectionConverters._
sealed trait VeevaConnectorOperator {
  def unwrap
      : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator
}
object VeevaConnectorOperator {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator
  ): zio.aws.appflow.model.VeevaConnectorOperator = value match {
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.PROJECTION =>
      val r = PROJECTION
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.LESS_THAN =>
      val r = LESS_THAN
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.GREATER_THAN =>
      val r = GREATER_THAN
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.CONTAINS =>
      val r = CONTAINS
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.BETWEEN =>
      val r = BETWEEN
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.LESS_THAN_OR_EQUAL_TO =>
      val r = LESS_THAN_OR_EQUAL_TO
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.GREATER_THAN_OR_EQUAL_TO =>
      val r = GREATER_THAN_OR_EQUAL_TO
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.EQUAL_TO =>
      val r = EQUAL_TO
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.NOT_EQUAL_TO =>
      val r = NOT_EQUAL_TO
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.ADDITION =>
      val r = ADDITION
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.MULTIPLICATION =>
      val r = MULTIPLICATION
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.DIVISION =>
      val r = DIVISION
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.SUBTRACTION =>
      val r = SUBTRACTION
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.MASK_ALL =>
      val r = MASK_ALL
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.MASK_FIRST_N =>
      val r = MASK_FIRST_N
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.MASK_LAST_N =>
      val r = MASK_LAST_N
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.VALIDATE_NON_NULL =>
      val r = VALIDATE_NON_NULL
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.VALIDATE_NON_ZERO =>
      val r = VALIDATE_NON_ZERO
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.VALIDATE_NON_NEGATIVE =>
      val r = VALIDATE_NON_NEGATIVE
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.VALIDATE_NUMERIC =>
      val r = VALIDATE_NUMERIC
      r
    case software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.NO_OP =>
      val r = NO_OP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object PROJECTION extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.PROJECTION
  }
  case object LESS_THAN extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.LESS_THAN
  }
  case object GREATER_THAN
      extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.GREATER_THAN
  }
  case object CONTAINS extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.CONTAINS
  }
  case object BETWEEN extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.BETWEEN
  }
  case object LESS_THAN_OR_EQUAL_TO
      extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.LESS_THAN_OR_EQUAL_TO
  }
  case object GREATER_THAN_OR_EQUAL_TO
      extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.GREATER_THAN_OR_EQUAL_TO
  }
  case object EQUAL_TO extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.EQUAL_TO
  }
  case object NOT_EQUAL_TO
      extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.NOT_EQUAL_TO
  }
  case object ADDITION extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.ADDITION
  }
  case object MULTIPLICATION
      extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.MULTIPLICATION
  }
  case object DIVISION extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.DIVISION
  }
  case object SUBTRACTION extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.SUBTRACTION
  }
  case object MASK_ALL extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.MASK_ALL
  }
  case object MASK_FIRST_N
      extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.MASK_FIRST_N
  }
  case object MASK_LAST_N extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.MASK_LAST_N
  }
  case object VALIDATE_NON_NULL
      extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.VALIDATE_NON_NULL
  }
  case object VALIDATE_NON_ZERO
      extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.VALIDATE_NON_ZERO
  }
  case object VALIDATE_NON_NEGATIVE
      extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.VALIDATE_NON_NEGATIVE
  }
  case object VALIDATE_NUMERIC
      extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.VALIDATE_NUMERIC
  }
  case object NO_OP extends zio.aws.appflow.model.VeevaConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator =
      software.amazon.awssdk.services.appflow.model.VeevaConnectorOperator.NO_OP
  }
}
