package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.{Password, Username}
import scala.jdk.CollectionConverters._
final case class VeevaConnectorProfileCredentials(
    username: Username,
    password: Password
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.VeevaConnectorProfileCredentials = {
    import VeevaConnectorProfileCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.VeevaConnectorProfileCredentials
      .builder()
      .username(Username.unwrap(username): java.lang.String)
      .password(Password.unwrap(password): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.VeevaConnectorProfileCredentials.ReadOnly =
    zio.aws.appflow.model.VeevaConnectorProfileCredentials.wrap(buildAwsValue())
}
object VeevaConnectorProfileCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.VeevaConnectorProfileCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.VeevaConnectorProfileCredentials =
      zio.aws.appflow.model.VeevaConnectorProfileCredentials(username, password)
    def username: Username
    def password: Password
    def getUsername: ZIO[Any, Nothing, Username] = ZIO.succeed(username)
    def getPassword: ZIO[Any, Nothing, Password] = ZIO.succeed(password)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.VeevaConnectorProfileCredentials
  ) extends zio.aws.appflow.model.VeevaConnectorProfileCredentials.ReadOnly {
    override val username: Username =
      zio.aws.appflow.model.primitives.Username(impl.username())
    override val password: Password =
      zio.aws.appflow.model.primitives.Password(impl.password())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.VeevaConnectorProfileCredentials
  ): zio.aws.appflow.model.VeevaConnectorProfileCredentials.ReadOnly =
    new Wrapper(impl)
}
