package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{DocumentType, Object}
import scala.jdk.CollectionConverters._
final case class VeevaSourceProperties(
    `object`: Object,
    documentType: Optional[DocumentType] = Optional.Absent,
    includeSourceFiles: Optional[Boolean] = Optional.Absent,
    includeRenditions: Optional[Boolean] = Optional.Absent,
    includeAllVersions: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.VeevaSourceProperties = {
    import VeevaSourceProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.VeevaSourceProperties
      .builder()
      .`object`(Object.unwrap(`object`): java.lang.String)
      .optionallyWith(
        documentType.map(value => DocumentType.unwrap(value): java.lang.String)
      )(_.documentType)
      .optionallyWith(
        includeSourceFiles.map(value => value: java.lang.Boolean)
      )(_.includeSourceFiles)
      .optionallyWith(includeRenditions.map(value => value: java.lang.Boolean))(
        _.includeRenditions
      )
      .optionallyWith(
        includeAllVersions.map(value => value: java.lang.Boolean)
      )(_.includeAllVersions)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.VeevaSourceProperties.ReadOnly =
    zio.aws.appflow.model.VeevaSourceProperties.wrap(buildAwsValue())
}
object VeevaSourceProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.VeevaSourceProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.VeevaSourceProperties =
      zio.aws.appflow.model.VeevaSourceProperties(
        `object`,
        documentType.map(value => value),
        includeSourceFiles.map(value => value),
        includeRenditions.map(value => value),
        includeAllVersions.map(value => value)
      )
    def `object`: Object
    def documentType: Optional[DocumentType]
    def includeSourceFiles: Optional[Boolean]
    def includeRenditions: Optional[Boolean]
    def includeAllVersions: Optional[Boolean]
    def getObject: ZIO[Any, Nothing, Object] = ZIO.succeed(`object`)
    def getDocumentType: ZIO[Any, AwsError, DocumentType] =
      AwsError.unwrapOptionField("documentType", documentType)
    def getIncludeSourceFiles: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeSourceFiles", includeSourceFiles)
    def getIncludeRenditions: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeRenditions", includeRenditions)
    def getIncludeAllVersions: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeAllVersions", includeAllVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.VeevaSourceProperties
  ) extends zio.aws.appflow.model.VeevaSourceProperties.ReadOnly {
    override val `object`: Object =
      zio.aws.appflow.model.primitives.Object(impl.`object`())
    override val documentType: Optional[DocumentType] = zio.aws.core.internal
      .optionalFromNullable(impl.documentType())
      .map(value => zio.aws.appflow.model.primitives.DocumentType(value))
    override val includeSourceFiles: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeSourceFiles())
      .map(value => value: Boolean)
    override val includeRenditions: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeRenditions())
      .map(value => value: Boolean)
    override val includeAllVersions: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeAllVersions())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.VeevaSourceProperties
  ): zio.aws.appflow.model.VeevaSourceProperties.ReadOnly = new Wrapper(impl)
}
