package zio.aws.appflow.model
import scala.jdk.CollectionConverters._
sealed trait ZendeskConnectorOperator {
  def unwrap
      : software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator
}
object ZendeskConnectorOperator {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator
  ): zio.aws.appflow.model.ZendeskConnectorOperator = value match {
    case software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.PROJECTION =>
      val r = PROJECTION
      r
    case software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.GREATER_THAN =>
      val r = GREATER_THAN
      r
    case software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.ADDITION =>
      val r = ADDITION
      r
    case software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.MULTIPLICATION =>
      val r = MULTIPLICATION
      r
    case software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.DIVISION =>
      val r = DIVISION
      r
    case software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.SUBTRACTION =>
      val r = SUBTRACTION
      r
    case software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.MASK_ALL =>
      val r = MASK_ALL
      r
    case software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.MASK_FIRST_N =>
      val r = MASK_FIRST_N
      r
    case software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.MASK_LAST_N =>
      val r = MASK_LAST_N
      r
    case software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.VALIDATE_NON_NULL =>
      val r = VALIDATE_NON_NULL
      r
    case software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.VALIDATE_NON_ZERO =>
      val r = VALIDATE_NON_ZERO
      r
    case software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.VALIDATE_NON_NEGATIVE =>
      val r = VALIDATE_NON_NEGATIVE
      r
    case software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.VALIDATE_NUMERIC =>
      val r = VALIDATE_NUMERIC
      r
    case software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.NO_OP =>
      val r = NO_OP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appflow.model.ZendeskConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator =
      software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object PROJECTION
      extends zio.aws.appflow.model.ZendeskConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator =
      software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.PROJECTION
  }
  case object GREATER_THAN
      extends zio.aws.appflow.model.ZendeskConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator =
      software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.GREATER_THAN
  }
  case object ADDITION extends zio.aws.appflow.model.ZendeskConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator =
      software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.ADDITION
  }
  case object MULTIPLICATION
      extends zio.aws.appflow.model.ZendeskConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator =
      software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.MULTIPLICATION
  }
  case object DIVISION extends zio.aws.appflow.model.ZendeskConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator =
      software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.DIVISION
  }
  case object SUBTRACTION
      extends zio.aws.appflow.model.ZendeskConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator =
      software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.SUBTRACTION
  }
  case object MASK_ALL extends zio.aws.appflow.model.ZendeskConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator =
      software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.MASK_ALL
  }
  case object MASK_FIRST_N
      extends zio.aws.appflow.model.ZendeskConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator =
      software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.MASK_FIRST_N
  }
  case object MASK_LAST_N
      extends zio.aws.appflow.model.ZendeskConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator =
      software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.MASK_LAST_N
  }
  case object VALIDATE_NON_NULL
      extends zio.aws.appflow.model.ZendeskConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator =
      software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.VALIDATE_NON_NULL
  }
  case object VALIDATE_NON_ZERO
      extends zio.aws.appflow.model.ZendeskConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator =
      software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.VALIDATE_NON_ZERO
  }
  case object VALIDATE_NON_NEGATIVE
      extends zio.aws.appflow.model.ZendeskConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator =
      software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.VALIDATE_NON_NEGATIVE
  }
  case object VALIDATE_NUMERIC
      extends zio.aws.appflow.model.ZendeskConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator =
      software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.VALIDATE_NUMERIC
  }
  case object NO_OP extends zio.aws.appflow.model.ZendeskConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator =
      software.amazon.awssdk.services.appflow.model.ZendeskConnectorOperator.NO_OP
  }
}
