package zio.aws.appflow
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.appflow.model.primitives.{
  Property,
  SupportedApiVersion,
  ConnectorMode,
  AuthCodeUrl,
  OAuthScope,
  TagValue,
  CredentialsMapKey,
  CredentialsMapValue,
  Group,
  TokenUrl,
  CustomPropertyKey,
  Value,
  ConnectorProfileName,
  ProfilePropertyKey,
  Region,
  Name,
  ProfilePropertyValue,
  ConnectorSuppliedValue,
  CustomPropertyValue,
  TagKey
}
import zio.aws.appflow.model.primitives.ApplicationType.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ARN extends Subtype[String]
    type ARN = zio.aws.appflow.model.primitives.ARN.Type
    object AccessKeyId extends Subtype[String]
    type AccessKeyId = zio.aws.appflow.model.primitives.AccessKeyId.Type
    object AccessToken extends Subtype[String]
    type AccessToken = zio.aws.appflow.model.primitives.AccessToken.Type
    object AccountName extends Subtype[String]
    type AccountName = zio.aws.appflow.model.primitives.AccountName.Type
    object ApiKey extends Subtype[String]
    type ApiKey = zio.aws.appflow.model.primitives.ApiKey.Type
    object ApiSecretKey extends Subtype[String]
    type ApiSecretKey = zio.aws.appflow.model.primitives.ApiSecretKey.Type
    object ApiToken extends Subtype[String]
    type ApiToken = zio.aws.appflow.model.primitives.ApiToken.Type
    object ApiVersion extends Subtype[String]
    type ApiVersion = zio.aws.appflow.model.primitives.ApiVersion.Type
    object ApplicationHostUrl extends Subtype[String]
    type ApplicationHostUrl =
      zio.aws.appflow.model.primitives.ApplicationHostUrl.Type
    object ApplicationKey extends Subtype[String]
    type ApplicationKey = zio.aws.appflow.model.primitives.ApplicationKey.Type
    object ApplicationServicePath extends Subtype[String]
    type ApplicationServicePath =
      zio.aws.appflow.model.primitives.ApplicationServicePath.Type
    object ApplicationType extends Subtype[String]
    type ApplicationType = zio.aws.appflow.model.primitives.ApplicationType.Type
    object AuthCode extends Subtype[String]
    type AuthCode = zio.aws.appflow.model.primitives.AuthCode.Type
    object AuthCodeUrl extends Subtype[String]
    type AuthCodeUrl = zio.aws.appflow.model.primitives.AuthCodeUrl.Type
    object BucketName extends Subtype[String]
    type BucketName = zio.aws.appflow.model.primitives.BucketName.Type
    object BucketPrefix extends Subtype[String]
    type BucketPrefix = zio.aws.appflow.model.primitives.BucketPrefix.Type
    object ClientCredentialsArn extends Subtype[String]
    type ClientCredentialsArn =
      zio.aws.appflow.model.primitives.ClientCredentialsArn.Type
    object ClientId extends Subtype[String]
    type ClientId = zio.aws.appflow.model.primitives.ClientId.Type
    object ClientNumber extends Subtype[String]
    type ClientNumber = zio.aws.appflow.model.primitives.ClientNumber.Type
    object ClientSecret extends Subtype[String]
    type ClientSecret = zio.aws.appflow.model.primitives.ClientSecret.Type
    object ConnectorDescription extends Subtype[String]
    type ConnectorDescription =
      zio.aws.appflow.model.primitives.ConnectorDescription.Type
    object ConnectorLabel extends Subtype[String]
    type ConnectorLabel = zio.aws.appflow.model.primitives.ConnectorLabel.Type
    object ConnectorMode extends Subtype[String]
    type ConnectorMode = zio.aws.appflow.model.primitives.ConnectorMode.Type
    object ConnectorName extends Subtype[String]
    type ConnectorName = zio.aws.appflow.model.primitives.ConnectorName.Type
    object ConnectorOwner extends Subtype[String]
    type ConnectorOwner = zio.aws.appflow.model.primitives.ConnectorOwner.Type
    object ConnectorProfileArn extends Subtype[String]
    type ConnectorProfileArn =
      zio.aws.appflow.model.primitives.ConnectorProfileArn.Type
    object ConnectorProfileName extends Subtype[String]
    type ConnectorProfileName =
      zio.aws.appflow.model.primitives.ConnectorProfileName.Type
    object ConnectorRuntimeSettingDataType extends Subtype[String]
    type ConnectorRuntimeSettingDataType =
      zio.aws.appflow.model.primitives.ConnectorRuntimeSettingDataType.Type
    object ConnectorRuntimeSettingScope extends Subtype[String]
    type ConnectorRuntimeSettingScope =
      zio.aws.appflow.model.primitives.ConnectorRuntimeSettingScope.Type
    object ConnectorSuppliedValue extends Subtype[String]
    type ConnectorSuppliedValue =
      zio.aws.appflow.model.primitives.ConnectorSuppliedValue.Type
    object ConnectorVersion extends Subtype[String]
    type ConnectorVersion =
      zio.aws.appflow.model.primitives.ConnectorVersion.Type
    object CreatedBy extends Subtype[String]
    type CreatedBy = zio.aws.appflow.model.primitives.CreatedBy.Type
    object CredentialsMapKey extends Subtype[String]
    type CredentialsMapKey =
      zio.aws.appflow.model.primitives.CredentialsMapKey.Type
    object CredentialsMapValue extends Subtype[String]
    type CredentialsMapValue =
      zio.aws.appflow.model.primitives.CredentialsMapValue.Type
    object CustomAuthenticationType extends Subtype[String]
    type CustomAuthenticationType =
      zio.aws.appflow.model.primitives.CustomAuthenticationType.Type
    object CustomPropertyKey extends Subtype[String]
    type CustomPropertyKey =
      zio.aws.appflow.model.primitives.CustomPropertyKey.Type
    object CustomPropertyValue extends Subtype[String]
    type CustomPropertyValue =
      zio.aws.appflow.model.primitives.CustomPropertyValue.Type
    object DatabaseUrl extends Subtype[String]
    type DatabaseUrl = zio.aws.appflow.model.primitives.DatabaseUrl.Type
    object Date extends Subtype[Instant]
    type Date = zio.aws.appflow.model.primitives.Date.Type
    object DatetimeTypeFieldName extends Subtype[String]
    type DatetimeTypeFieldName =
      zio.aws.appflow.model.primitives.DatetimeTypeFieldName.Type
    object Description extends Subtype[String]
    type Description = zio.aws.appflow.model.primitives.Description.Type
    object DestinationField extends Subtype[String]
    type DestinationField =
      zio.aws.appflow.model.primitives.DestinationField.Type
    object DocumentType extends Subtype[String]
    type DocumentType = zio.aws.appflow.model.primitives.DocumentType.Type
    object DomainName extends Subtype[String]
    type DomainName = zio.aws.appflow.model.primitives.DomainName.Type
    object EntitiesPath extends Subtype[String]
    type EntitiesPath = zio.aws.appflow.model.primitives.EntitiesPath.Type
    object EntityName extends Subtype[String]
    type EntityName = zio.aws.appflow.model.primitives.EntityName.Type
    object ExecutionId extends Subtype[String]
    type ExecutionId = zio.aws.appflow.model.primitives.ExecutionId.Type
    object ExecutionMessage extends Subtype[String]
    type ExecutionMessage =
      zio.aws.appflow.model.primitives.ExecutionMessage.Type
    object FieldType extends Subtype[String]
    type FieldType = zio.aws.appflow.model.primitives.FieldType.Type
    object FlowArn extends Subtype[String]
    type FlowArn = zio.aws.appflow.model.primitives.FlowArn.Type
    object FlowDescription extends Subtype[String]
    type FlowDescription = zio.aws.appflow.model.primitives.FlowDescription.Type
    object FlowErrorDeactivationThreshold extends Subtype[Int]
    type FlowErrorDeactivationThreshold =
      zio.aws.appflow.model.primitives.FlowErrorDeactivationThreshold.Type
    object FlowName extends Subtype[String]
    type FlowName = zio.aws.appflow.model.primitives.FlowName.Type
    object FlowStatusMessage extends Subtype[String]
    type FlowStatusMessage =
      zio.aws.appflow.model.primitives.FlowStatusMessage.Type
    object Group extends Subtype[String]
    type Group = zio.aws.appflow.model.primitives.Group.Type
    object Identifier extends Subtype[String]
    type Identifier = zio.aws.appflow.model.primitives.Identifier.Type
    object InstanceUrl extends Subtype[String]
    type InstanceUrl = zio.aws.appflow.model.primitives.InstanceUrl.Type
    object JavaBoolean extends Subtype[Boolean]
    type JavaBoolean = zio.aws.appflow.model.primitives.JavaBoolean.Type
    object KMSArn extends Subtype[String]
    type KMSArn = zio.aws.appflow.model.primitives.KMSArn.Type
    object Key extends Subtype[String]
    type Key = zio.aws.appflow.model.primitives.Key.Type
    object Label extends Subtype[String]
    type Label = zio.aws.appflow.model.primitives.Label.Type
    object LogoURL extends Subtype[String]
    type LogoURL = zio.aws.appflow.model.primitives.LogoURL.Type
    object LogonLanguage extends Subtype[String]
    type LogonLanguage = zio.aws.appflow.model.primitives.LogonLanguage.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.appflow.model.primitives.MaxResults.Type
    object MostRecentExecutionMessage extends Subtype[String]
    type MostRecentExecutionMessage =
      zio.aws.appflow.model.primitives.MostRecentExecutionMessage.Type
    object Name extends Subtype[String]
    type Name = zio.aws.appflow.model.primitives.Name.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.appflow.model.primitives.NextToken.Type
    object OAuthScope extends Subtype[String]
    type OAuthScope = zio.aws.appflow.model.primitives.OAuthScope.Type
    object Object extends Subtype[String]
    type Object = zio.aws.appflow.model.primitives.Object.Type
    object ObjectTypeName extends Subtype[String]
    type ObjectTypeName = zio.aws.appflow.model.primitives.ObjectTypeName.Type
    object Password extends Subtype[String]
    type Password = zio.aws.appflow.model.primitives.Password.Type
    object PortNumber extends Subtype[Int]
    type PortNumber = zio.aws.appflow.model.primitives.PortNumber.Type
    object PrivateConnectionProvisioningFailureMessage extends Subtype[String]
    type PrivateConnectionProvisioningFailureMessage =
      zio.aws.appflow.model.primitives.PrivateConnectionProvisioningFailureMessage.Type
    object PrivateLinkServiceName extends Subtype[String]
    type PrivateLinkServiceName =
      zio.aws.appflow.model.primitives.PrivateLinkServiceName.Type
    object ProfilePropertyKey extends Subtype[String]
    type ProfilePropertyKey =
      zio.aws.appflow.model.primitives.ProfilePropertyKey.Type
    object ProfilePropertyValue extends Subtype[String]
    type ProfilePropertyValue =
      zio.aws.appflow.model.primitives.ProfilePropertyValue.Type
    object Property extends Subtype[String]
    type Property = zio.aws.appflow.model.primitives.Property.Type
    object RedirectUri extends Subtype[String]
    type RedirectUri = zio.aws.appflow.model.primitives.RedirectUri.Type
    object RefreshToken extends Subtype[String]
    type RefreshToken = zio.aws.appflow.model.primitives.RefreshToken.Type
    object Region extends Subtype[String]
    type Region = zio.aws.appflow.model.primitives.Region.Type
    object RegisteredBy extends Subtype[String]
    type RegisteredBy = zio.aws.appflow.model.primitives.RegisteredBy.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.appflow.model.primitives.RoleArn.Type
    object ScheduleExpression extends Subtype[String]
    type ScheduleExpression =
      zio.aws.appflow.model.primitives.ScheduleExpression.Type
    object ScheduleOffset extends Subtype[Long]
    type ScheduleOffset = zio.aws.appflow.model.primitives.ScheduleOffset.Type
    object SecretKey extends Subtype[String]
    type SecretKey = zio.aws.appflow.model.primitives.SecretKey.Type
    object Stage extends Subtype[String]
    type Stage = zio.aws.appflow.model.primitives.Stage.Type
    object SupportedApiVersion extends Subtype[String]
    type SupportedApiVersion =
      zio.aws.appflow.model.primitives.SupportedApiVersion.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.appflow.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.appflow.model.primitives.TagValue.Type
    object Timezone extends Subtype[String]
    type Timezone = zio.aws.appflow.model.primitives.Timezone.Type
    object TokenUrl extends Subtype[String]
    type TokenUrl = zio.aws.appflow.model.primitives.TokenUrl.Type
    object UpdatedBy extends Subtype[String]
    type UpdatedBy = zio.aws.appflow.model.primitives.UpdatedBy.Type
    object UpsolverBucketName extends Subtype[String]
    type UpsolverBucketName =
      zio.aws.appflow.model.primitives.UpsolverBucketName.Type
    object Username extends Subtype[String]
    type Username = zio.aws.appflow.model.primitives.Username.Type
    object Value extends Subtype[String]
    type Value = zio.aws.appflow.model.primitives.Value.Type
    object Warehouse extends Subtype[String]
    type Warehouse = zio.aws.appflow.model.primitives.Warehouse.Type
  }
  type AuthCodeUrlList = List[AuthCodeUrl]
  type AuthParameterList = List[zio.aws.appflow.model.AuthParameter]
  type ConnectorConfigurationsMap = Map[
    zio.aws.appflow.model.ConnectorType,
    zio.aws.appflow.model.ConnectorConfiguration
  ]
  type ConnectorEntityFieldList =
    List[zio.aws.appflow.model.ConnectorEntityField]
  type ConnectorEntityList = List[zio.aws.appflow.model.ConnectorEntity]
  type ConnectorEntityMap =
    Map[Group, Iterable[zio.aws.appflow.model.ConnectorEntity]]
  type ConnectorList = List[zio.aws.appflow.model.ConnectorDetail]
  type ConnectorModeList = List[ConnectorMode]
  type ConnectorProfileDetailList = List[zio.aws.appflow.model.ConnectorProfile]
  type ConnectorProfileNameList = List[ConnectorProfileName]
  type ConnectorRuntimeSettingList =
    List[zio.aws.appflow.model.ConnectorRuntimeSetting]
  type ConnectorSuppliedValueList = List[ConnectorSuppliedValue]
  type ConnectorSuppliedValueOptionList = List[ConnectorSuppliedValue]
  type ConnectorTypeList = List[zio.aws.appflow.model.ConnectorType]
  type CredentialsMap = Map[CredentialsMapKey, CredentialsMapValue]
  type CustomAuthConfigList = List[zio.aws.appflow.model.CustomAuthConfig]
  type CustomProperties = Map[CustomPropertyKey, CustomPropertyValue]
  type DestinationFlowConfigList =
    List[zio.aws.appflow.model.DestinationFlowConfig]
  type FilterOperatorList = List[zio.aws.appflow.model.Operator]
  type FlowExecutionList = List[zio.aws.appflow.model.ExecutionRecord]
  type FlowList = List[zio.aws.appflow.model.FlowDefinition]
  type IdFieldNameList = List[Name]
  type OAuth2CustomPropertiesList =
    List[zio.aws.appflow.model.OAuth2CustomParameter]
  type OAuth2GrantTypeSupportedList =
    List[zio.aws.appflow.model.OAuth2GrantType]
  type OAuthScopeList = List[OAuthScope]
  type ProfilePropertiesMap = Map[ProfilePropertyKey, ProfilePropertyValue]
  type RegionList = List[Region]
  type SchedulingFrequencyTypeList =
    List[zio.aws.appflow.model.ScheduleFrequencyType]
  type SourceFields = List[String]
  type SupportedApiVersionList = List[SupportedApiVersion]
  type SupportedOperatorList = List[zio.aws.appflow.model.Operators]
  type SupportedValueList = List[Value]
  type SupportedWriteOperationList =
    List[zio.aws.appflow.model.WriteOperationType]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type TaskPropertiesMap =
    Map[zio.aws.appflow.model.OperatorPropertiesKeys, Property]
  type Tasks = List[zio.aws.appflow.model.Task]
  type TokenUrlCustomProperties = Map[CustomPropertyKey, CustomPropertyValue]
  type TokenUrlList = List[TokenUrl]
  type TriggerTypeList = List[zio.aws.appflow.model.TriggerType]
}
