package zio.aws.appflow
import zio.aws.appflow.model.StopFlowResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.appflow.model.{
  DeleteFlowRequest,
  DescribeConnectorEntityRequest,
  DeleteConnectorProfileRequest,
  StartFlowRequest,
  DescribeFlowExecutionRecordsRequest,
  DescribeConnectorRequest,
  StopFlowRequest,
  DescribeConnectorsRequest,
  ListTagsForResourceRequest,
  ListConnectorEntitiesRequest,
  ListFlowsRequest,
  RegisterConnectorRequest,
  DescribeConnectorProfilesRequest,
  CreateConnectorProfileRequest,
  ListConnectorsRequest,
  UpdateFlowRequest,
  UntagResourceRequest,
  UnregisterConnectorRequest,
  DescribeFlowRequest,
  CreateFlowRequest,
  UpdateConnectorProfileRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.appflow.AppflowAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
object AppflowMock extends Mock[Appflow] {
  object StopFlow extends Effect[StopFlowRequest, AwsError, ReadOnly]
  object StartFlow
      extends Effect[
        StartFlowRequest,
        AwsError,
        zio.aws.appflow.model.StartFlowResponse.ReadOnly
      ]
  object UpdateFlow
      extends Effect[
        UpdateFlowRequest,
        AwsError,
        zio.aws.appflow.model.UpdateFlowResponse.ReadOnly
      ]
  object CreateConnectorProfile
      extends Effect[
        CreateConnectorProfileRequest,
        AwsError,
        zio.aws.appflow.model.CreateConnectorProfileResponse.ReadOnly
      ]
  object RegisterConnector
      extends Effect[
        RegisterConnectorRequest,
        AwsError,
        zio.aws.appflow.model.RegisterConnectorResponse.ReadOnly
      ]
  object DeleteFlow
      extends Effect[
        DeleteFlowRequest,
        AwsError,
        zio.aws.appflow.model.DeleteFlowResponse.ReadOnly
      ]
  object DescribeConnector
      extends Effect[
        DescribeConnectorRequest,
        AwsError,
        zio.aws.appflow.model.DescribeConnectorResponse.ReadOnly
      ]
  object ListFlows
      extends Effect[
        ListFlowsRequest,
        AwsError,
        zio.aws.appflow.model.ListFlowsResponse.ReadOnly
      ]
  object DeleteConnectorProfile
      extends Effect[
        DeleteConnectorProfileRequest,
        AwsError,
        zio.aws.appflow.model.DeleteConnectorProfileResponse.ReadOnly
      ]
  object DescribeFlowExecutionRecords
      extends Effect[
        DescribeFlowExecutionRecordsRequest,
        AwsError,
        zio.aws.appflow.model.DescribeFlowExecutionRecordsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.appflow.model.UntagResourceResponse.ReadOnly
      ]
  object DescribeFlow
      extends Effect[
        DescribeFlowRequest,
        AwsError,
        zio.aws.appflow.model.DescribeFlowResponse.ReadOnly
      ]
  object ListConnectorEntities
      extends Effect[
        ListConnectorEntitiesRequest,
        AwsError,
        zio.aws.appflow.model.ListConnectorEntitiesResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.appflow.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.appflow.model.TagResourceResponse.ReadOnly
      ]
  object UpdateConnectorProfile
      extends Effect[
        UpdateConnectorProfileRequest,
        AwsError,
        zio.aws.appflow.model.UpdateConnectorProfileResponse.ReadOnly
      ]
  object DescribeConnectorProfiles
      extends Effect[
        DescribeConnectorProfilesRequest,
        AwsError,
        zio.aws.appflow.model.DescribeConnectorProfilesResponse.ReadOnly
      ]
  object DescribeConnectors
      extends Effect[
        DescribeConnectorsRequest,
        AwsError,
        zio.aws.appflow.model.DescribeConnectorsResponse.ReadOnly
      ]
  object DescribeConnectorEntity
      extends Effect[
        DescribeConnectorEntityRequest,
        AwsError,
        zio.aws.appflow.model.DescribeConnectorEntityResponse.ReadOnly
      ]
  object CreateFlow
      extends Effect[
        CreateFlowRequest,
        AwsError,
        zio.aws.appflow.model.CreateFlowResponse.ReadOnly
      ]
  object UnregisterConnector
      extends Effect[
        UnregisterConnectorRequest,
        AwsError,
        zio.aws.appflow.model.UnregisterConnectorResponse.ReadOnly
      ]
  object ListConnectors
      extends Effect[
        ListConnectorsRequest,
        AwsError,
        zio.aws.appflow.model.ListConnectorsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Appflow] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Appflow] { rts =>
        zio.ZIO.succeed {
          new Appflow {
            val api: AppflowAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Appflow = this
            def stopFlow(request: StopFlowRequest): IO[AwsError, ReadOnly] =
              proxy(StopFlow, request)
            def startFlow(
                request: StartFlowRequest
            ): IO[AwsError, zio.aws.appflow.model.StartFlowResponse.ReadOnly] =
              proxy(StartFlow, request)
            def updateFlow(
                request: UpdateFlowRequest
            ): IO[AwsError, zio.aws.appflow.model.UpdateFlowResponse.ReadOnly] =
              proxy(UpdateFlow, request)
            def createConnectorProfile(
                request: CreateConnectorProfileRequest
            ): IO[
              AwsError,
              zio.aws.appflow.model.CreateConnectorProfileResponse.ReadOnly
            ] = proxy(CreateConnectorProfile, request)
            def registerConnector(request: RegisterConnectorRequest): IO[
              AwsError,
              zio.aws.appflow.model.RegisterConnectorResponse.ReadOnly
            ] = proxy(RegisterConnector, request)
            def deleteFlow(
                request: DeleteFlowRequest
            ): IO[AwsError, zio.aws.appflow.model.DeleteFlowResponse.ReadOnly] =
              proxy(DeleteFlow, request)
            def describeConnector(request: DescribeConnectorRequest): IO[
              AwsError,
              zio.aws.appflow.model.DescribeConnectorResponse.ReadOnly
            ] = proxy(DescribeConnector, request)
            def listFlows(
                request: ListFlowsRequest
            ): IO[AwsError, zio.aws.appflow.model.ListFlowsResponse.ReadOnly] =
              proxy(ListFlows, request)
            def deleteConnectorProfile(
                request: DeleteConnectorProfileRequest
            ): IO[
              AwsError,
              zio.aws.appflow.model.DeleteConnectorProfileResponse.ReadOnly
            ] = proxy(DeleteConnectorProfile, request)
            def describeFlowExecutionRecords(
                request: DescribeFlowExecutionRecordsRequest
            ): IO[
              AwsError,
              zio.aws.appflow.model.DescribeFlowExecutionRecordsResponse.ReadOnly
            ] = proxy(DescribeFlowExecutionRecords, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.appflow.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def describeFlow(request: DescribeFlowRequest): IO[
              AwsError,
              zio.aws.appflow.model.DescribeFlowResponse.ReadOnly
            ] = proxy(DescribeFlow, request)
            def listConnectorEntities(
                request: ListConnectorEntitiesRequest
            ): IO[
              AwsError,
              zio.aws.appflow.model.ListConnectorEntitiesResponse.ReadOnly
            ] = proxy(ListConnectorEntities, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.appflow.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.appflow.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def updateConnectorProfile(
                request: UpdateConnectorProfileRequest
            ): IO[
              AwsError,
              zio.aws.appflow.model.UpdateConnectorProfileResponse.ReadOnly
            ] = proxy(UpdateConnectorProfile, request)
            def describeConnectorProfiles(
                request: DescribeConnectorProfilesRequest
            ): IO[
              AwsError,
              zio.aws.appflow.model.DescribeConnectorProfilesResponse.ReadOnly
            ] = proxy(DescribeConnectorProfiles, request)
            def describeConnectors(request: DescribeConnectorsRequest): IO[
              AwsError,
              zio.aws.appflow.model.DescribeConnectorsResponse.ReadOnly
            ] = proxy(DescribeConnectors, request)
            def describeConnectorEntity(
                request: DescribeConnectorEntityRequest
            ): IO[
              AwsError,
              zio.aws.appflow.model.DescribeConnectorEntityResponse.ReadOnly
            ] = proxy(DescribeConnectorEntity, request)
            def createFlow(
                request: CreateFlowRequest
            ): IO[AwsError, zio.aws.appflow.model.CreateFlowResponse.ReadOnly] =
              proxy(CreateFlow, request)
            def unregisterConnector(request: UnregisterConnectorRequest): IO[
              AwsError,
              zio.aws.appflow.model.UnregisterConnectorResponse.ReadOnly
            ] = proxy(UnregisterConnector, request)
            def listConnectors(request: ListConnectorsRequest): IO[
              AwsError,
              zio.aws.appflow.model.ListConnectorsResponse.ReadOnly
            ] = proxy(ListConnectors, request)
          }
        }
      }
    }
  }
}
