package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AggregationConfig(
    aggregationType: Optional[zio.aws.appflow.model.AggregationType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.AggregationConfig = {
    import AggregationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.AggregationConfig
      .builder()
      .optionallyWith(aggregationType.map(value => value.unwrap))(
        _.aggregationType
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.AggregationConfig.ReadOnly =
    zio.aws.appflow.model.AggregationConfig.wrap(buildAwsValue())
}
object AggregationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.AggregationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.AggregationConfig =
      zio.aws.appflow.model
        .AggregationConfig(aggregationType.map(value => value))
    def aggregationType: Optional[zio.aws.appflow.model.AggregationType]
    def getAggregationType
        : ZIO[Any, AwsError, zio.aws.appflow.model.AggregationType] =
      AwsError.unwrapOptionField("aggregationType", aggregationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.AggregationConfig
  ) extends zio.aws.appflow.model.AggregationConfig.ReadOnly {
    override val aggregationType
        : Optional[zio.aws.appflow.model.AggregationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregationType())
        .map(value => zio.aws.appflow.model.AggregationType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.AggregationConfig
  ): zio.aws.appflow.model.AggregationConfig.ReadOnly = new Wrapper(impl)
}
