package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{ApiSecretKey, ApiKey}
import scala.jdk.CollectionConverters.*
final case class ApiKeyCredentials(
    apiKey: ApiKey,
    apiSecretKey: Optional[ApiSecretKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ApiKeyCredentials = {
    import ApiKeyCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ApiKeyCredentials
      .builder()
      .apiKey(ApiKey.unwrap(apiKey): java.lang.String)
      .optionallyWith(
        apiSecretKey.map(value => ApiSecretKey.unwrap(value): java.lang.String)
      )(_.apiSecretKey)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ApiKeyCredentials.ReadOnly =
    zio.aws.appflow.model.ApiKeyCredentials.wrap(buildAwsValue())
}
object ApiKeyCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ApiKeyCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ApiKeyCredentials =
      zio.aws.appflow.model
        .ApiKeyCredentials(apiKey, apiSecretKey.map(value => value))
    def apiKey: ApiKey
    def apiSecretKey: Optional[ApiSecretKey]
    def getApiKey: ZIO[Any, Nothing, ApiKey] = ZIO.succeed(apiKey)
    def getApiSecretKey: ZIO[Any, AwsError, ApiSecretKey] =
      AwsError.unwrapOptionField("apiSecretKey", apiSecretKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ApiKeyCredentials
  ) extends zio.aws.appflow.model.ApiKeyCredentials.ReadOnly {
    override val apiKey: ApiKey =
      zio.aws.appflow.model.primitives.ApiKey(impl.apiKey())
    override val apiSecretKey: Optional[ApiSecretKey] = zio.aws.core.internal
      .optionalFromNullable(impl.apiSecretKey())
      .map(value => zio.aws.appflow.model.primitives.ApiSecretKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ApiKeyCredentials
  ): zio.aws.appflow.model.ApiKeyCredentials.ReadOnly = new Wrapper(impl)
}
