package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{
  ConnectorSuppliedValue,
  Description,
  Label,
  Key
}
import scala.jdk.CollectionConverters.*
final case class AuthParameter(
    key: Optional[Key] = Optional.Absent,
    isRequired: Optional[Boolean] = Optional.Absent,
    label: Optional[Label] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    isSensitiveField: Optional[Boolean] = Optional.Absent,
    connectorSuppliedValues: Optional[Iterable[ConnectorSuppliedValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.AuthParameter = {
    import AuthParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.AuthParameter
      .builder()
      .optionallyWith(key.map(value => Key.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(isRequired.map(value => value: java.lang.Boolean))(
        _.isRequired
      )
      .optionallyWith(
        label.map(value => Label.unwrap(value): java.lang.String)
      )(_.label)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(isSensitiveField.map(value => value: java.lang.Boolean))(
        _.isSensitiveField
      )
      .optionallyWith(
        connectorSuppliedValues.map(value =>
          value.map { item =>
            ConnectorSuppliedValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.connectorSuppliedValues)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.AuthParameter.ReadOnly =
    zio.aws.appflow.model.AuthParameter.wrap(buildAwsValue())
}
object AuthParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.AuthParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.AuthParameter =
      zio.aws.appflow.model.AuthParameter(
        key.map(value => value),
        isRequired.map(value => value),
        label.map(value => value),
        description.map(value => value),
        isSensitiveField.map(value => value),
        connectorSuppliedValues.map(value => value)
      )
    def key: Optional[Key]
    def isRequired: Optional[Boolean]
    def label: Optional[Label]
    def description: Optional[Description]
    def isSensitiveField: Optional[Boolean]
    def connectorSuppliedValues: Optional[List[ConnectorSuppliedValue]]
    def getKey: ZIO[Any, AwsError, Key] = AwsError.unwrapOptionField("key", key)
    def getIsRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isRequired", isRequired)
    def getLabel: ZIO[Any, AwsError, Label] =
      AwsError.unwrapOptionField("label", label)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getIsSensitiveField: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSensitiveField", isSensitiveField)
    def getConnectorSuppliedValues
        : ZIO[Any, AwsError, List[ConnectorSuppliedValue]] = AwsError
      .unwrapOptionField("connectorSuppliedValues", connectorSuppliedValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.AuthParameter
  ) extends zio.aws.appflow.model.AuthParameter.ReadOnly {
    override val key: Optional[Key] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.appflow.model.primitives.Key(value))
    override val isRequired: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isRequired())
      .map(value => value: Boolean)
    override val label: Optional[Label] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => zio.aws.appflow.model.primitives.Label(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appflow.model.primitives.Description(value))
    override val isSensitiveField: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isSensitiveField())
      .map(value => value: Boolean)
    override val connectorSuppliedValues
        : Optional[List[ConnectorSuppliedValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorSuppliedValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appflow.model.primitives.ConnectorSuppliedValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.AuthParameter
  ): zio.aws.appflow.model.AuthParameter.ReadOnly = new Wrapper(impl)
}
