package zio.aws.appflow.model
import scala.jdk.CollectionConverters.*
sealed trait ConnectionMode {
  def unwrap: software.amazon.awssdk.services.appflow.model.ConnectionMode
}
object ConnectionMode {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.ConnectionMode
  ): zio.aws.appflow.model.ConnectionMode = value match {
    case software.amazon.awssdk.services.appflow.model.ConnectionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.ConnectionMode.PUBLIC =>
      val r = Public
      r
    case software.amazon.awssdk.services.appflow.model.ConnectionMode.PRIVATE =>
      val r = Private
      r
  }
  case object unknownToSdkVersion extends zio.aws.appflow.model.ConnectionMode {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectionMode =
      software.amazon.awssdk.services.appflow.model.ConnectionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object Public extends zio.aws.appflow.model.ConnectionMode {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectionMode =
      software.amazon.awssdk.services.appflow.model.ConnectionMode.PUBLIC
  }
  case object Private extends zio.aws.appflow.model.ConnectionMode {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.ConnectionMode =
      software.amazon.awssdk.services.appflow.model.ConnectionMode.PRIVATE
  }
}
