package zio.aws.appflow.model
import zio.aws.appflow.model.primitives.{
  SupportedApiVersion,
  ConnectorMode,
  Date,
  ConnectorOwner,
  RegisteredBy,
  ConnectorName,
  ConnectorLabel,
  ConnectorDescription,
  LogoURL,
  ConnectorVersion,
  ARN
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ConnectorConfiguration(
    canUseAsSource: Optional[Boolean] = Optional.Absent,
    canUseAsDestination: Optional[Boolean] = Optional.Absent,
    supportedDestinationConnectors: Optional[
      Iterable[zio.aws.appflow.model.ConnectorType]
    ] = Optional.Absent,
    supportedSchedulingFrequencies: Optional[
      Iterable[zio.aws.appflow.model.ScheduleFrequencyType]
    ] = Optional.Absent,
    isPrivateLinkEnabled: Optional[Boolean] = Optional.Absent,
    isPrivateLinkEndpointUrlRequired: Optional[Boolean] = Optional.Absent,
    supportedTriggerTypes: Optional[
      Iterable[zio.aws.appflow.model.TriggerType]
    ] = Optional.Absent,
    connectorMetadata: Optional[zio.aws.appflow.model.ConnectorMetadata] =
      Optional.Absent,
    connectorType: Optional[zio.aws.appflow.model.ConnectorType] =
      Optional.Absent,
    connectorLabel: Optional[ConnectorLabel] = Optional.Absent,
    connectorDescription: Optional[ConnectorDescription] = Optional.Absent,
    connectorOwner: Optional[ConnectorOwner] = Optional.Absent,
    connectorName: Optional[ConnectorName] = Optional.Absent,
    connectorVersion: Optional[ConnectorVersion] = Optional.Absent,
    connectorArn: Optional[ARN] = Optional.Absent,
    connectorModes: Optional[Iterable[ConnectorMode]] = Optional.Absent,
    authenticationConfig: Optional[zio.aws.appflow.model.AuthenticationConfig] =
      Optional.Absent,
    connectorRuntimeSettings: Optional[
      Iterable[zio.aws.appflow.model.ConnectorRuntimeSetting]
    ] = Optional.Absent,
    supportedApiVersions: Optional[Iterable[SupportedApiVersion]] =
      Optional.Absent,
    supportedOperators: Optional[Iterable[zio.aws.appflow.model.Operators]] =
      Optional.Absent,
    supportedWriteOperations: Optional[
      Iterable[zio.aws.appflow.model.WriteOperationType]
    ] = Optional.Absent,
    connectorProvisioningType: Optional[
      zio.aws.appflow.model.ConnectorProvisioningType
    ] = Optional.Absent,
    connectorProvisioningConfig: Optional[
      zio.aws.appflow.model.ConnectorProvisioningConfig
    ] = Optional.Absent,
    logoURL: Optional[LogoURL] = Optional.Absent,
    registeredAt: Optional[Date] = Optional.Absent,
    registeredBy: Optional[RegisteredBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ConnectorConfiguration = {
    import ConnectorConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ConnectorConfiguration
      .builder()
      .optionallyWith(canUseAsSource.map(value => value: java.lang.Boolean))(
        _.canUseAsSource
      )
      .optionallyWith(
        canUseAsDestination.map(value => value: java.lang.Boolean)
      )(_.canUseAsDestination)
      .optionallyWith(
        supportedDestinationConnectors.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedDestinationConnectorsWithStrings)
      .optionallyWith(
        supportedSchedulingFrequencies.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedSchedulingFrequenciesWithStrings)
      .optionallyWith(
        isPrivateLinkEnabled.map(value => value: java.lang.Boolean)
      )(_.isPrivateLinkEnabled)
      .optionallyWith(
        isPrivateLinkEndpointUrlRequired.map(value => value: java.lang.Boolean)
      )(_.isPrivateLinkEndpointUrlRequired)
      .optionallyWith(
        supportedTriggerTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedTriggerTypesWithStrings)
      .optionallyWith(connectorMetadata.map(value => value.buildAwsValue()))(
        _.connectorMetadata
      )
      .optionallyWith(connectorType.map(value => value.unwrap))(_.connectorType)
      .optionallyWith(
        connectorLabel.map(value =>
          ConnectorLabel.unwrap(value): java.lang.String
        )
      )(_.connectorLabel)
      .optionallyWith(
        connectorDescription.map(value =>
          ConnectorDescription.unwrap(value): java.lang.String
        )
      )(_.connectorDescription)
      .optionallyWith(
        connectorOwner.map(value =>
          ConnectorOwner.unwrap(value): java.lang.String
        )
      )(_.connectorOwner)
      .optionallyWith(
        connectorName.map(value =>
          ConnectorName.unwrap(value): java.lang.String
        )
      )(_.connectorName)
      .optionallyWith(
        connectorVersion.map(value =>
          ConnectorVersion.unwrap(value): java.lang.String
        )
      )(_.connectorVersion)
      .optionallyWith(
        connectorArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.connectorArn)
      .optionallyWith(
        connectorModes.map(value =>
          value.map { item =>
            ConnectorMode.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.connectorModes)
      .optionallyWith(authenticationConfig.map(value => value.buildAwsValue()))(
        _.authenticationConfig
      )
      .optionallyWith(
        connectorRuntimeSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connectorRuntimeSettings)
      .optionallyWith(
        supportedApiVersions.map(value =>
          value.map { item =>
            SupportedApiVersion.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedApiVersions)
      .optionallyWith(
        supportedOperators.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedOperatorsWithStrings)
      .optionallyWith(
        supportedWriteOperations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedWriteOperationsWithStrings)
      .optionallyWith(connectorProvisioningType.map(value => value.unwrap))(
        _.connectorProvisioningType
      )
      .optionallyWith(
        connectorProvisioningConfig.map(value => value.buildAwsValue())
      )(_.connectorProvisioningConfig)
      .optionallyWith(
        logoURL.map(value => LogoURL.unwrap(value): java.lang.String)
      )(_.logoURL)
      .optionallyWith(registeredAt.map(value => Date.unwrap(value): Instant))(
        _.registeredAt
      )
      .optionallyWith(
        registeredBy.map(value => RegisteredBy.unwrap(value): java.lang.String)
      )(_.registeredBy)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ConnectorConfiguration.ReadOnly =
    zio.aws.appflow.model.ConnectorConfiguration.wrap(buildAwsValue())
}
object ConnectorConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ConnectorConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ConnectorConfiguration =
      zio.aws.appflow.model.ConnectorConfiguration(
        canUseAsSource.map(value => value),
        canUseAsDestination.map(value => value),
        supportedDestinationConnectors.map(value => value),
        supportedSchedulingFrequencies.map(value => value),
        isPrivateLinkEnabled.map(value => value),
        isPrivateLinkEndpointUrlRequired.map(value => value),
        supportedTriggerTypes.map(value => value),
        connectorMetadata.map(value => value.asEditable),
        connectorType.map(value => value),
        connectorLabel.map(value => value),
        connectorDescription.map(value => value),
        connectorOwner.map(value => value),
        connectorName.map(value => value),
        connectorVersion.map(value => value),
        connectorArn.map(value => value),
        connectorModes.map(value => value),
        authenticationConfig.map(value => value.asEditable),
        connectorRuntimeSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        supportedApiVersions.map(value => value),
        supportedOperators.map(value => value),
        supportedWriteOperations.map(value => value),
        connectorProvisioningType.map(value => value),
        connectorProvisioningConfig.map(value => value.asEditable),
        logoURL.map(value => value),
        registeredAt.map(value => value),
        registeredBy.map(value => value)
      )
    def canUseAsSource: Optional[Boolean]
    def canUseAsDestination: Optional[Boolean]
    def supportedDestinationConnectors
        : Optional[List[zio.aws.appflow.model.ConnectorType]]
    def supportedSchedulingFrequencies
        : Optional[List[zio.aws.appflow.model.ScheduleFrequencyType]]
    def isPrivateLinkEnabled: Optional[Boolean]
    def isPrivateLinkEndpointUrlRequired: Optional[Boolean]
    def supportedTriggerTypes: Optional[List[zio.aws.appflow.model.TriggerType]]
    def connectorMetadata
        : Optional[zio.aws.appflow.model.ConnectorMetadata.ReadOnly]
    def connectorType: Optional[zio.aws.appflow.model.ConnectorType]
    def connectorLabel: Optional[ConnectorLabel]
    def connectorDescription: Optional[ConnectorDescription]
    def connectorOwner: Optional[ConnectorOwner]
    def connectorName: Optional[ConnectorName]
    def connectorVersion: Optional[ConnectorVersion]
    def connectorArn: Optional[ARN]
    def connectorModes: Optional[List[ConnectorMode]]
    def authenticationConfig
        : Optional[zio.aws.appflow.model.AuthenticationConfig.ReadOnly]
    def connectorRuntimeSettings
        : Optional[List[zio.aws.appflow.model.ConnectorRuntimeSetting.ReadOnly]]
    def supportedApiVersions: Optional[List[SupportedApiVersion]]
    def supportedOperators: Optional[List[zio.aws.appflow.model.Operators]]
    def supportedWriteOperations
        : Optional[List[zio.aws.appflow.model.WriteOperationType]]
    def connectorProvisioningType
        : Optional[zio.aws.appflow.model.ConnectorProvisioningType]
    def connectorProvisioningConfig
        : Optional[zio.aws.appflow.model.ConnectorProvisioningConfig.ReadOnly]
    def logoURL: Optional[LogoURL]
    def registeredAt: Optional[Date]
    def registeredBy: Optional[RegisteredBy]
    def getCanUseAsSource: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("canUseAsSource", canUseAsSource)
    def getCanUseAsDestination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("canUseAsDestination", canUseAsDestination)
    def getSupportedDestinationConnectors
        : ZIO[Any, AwsError, List[zio.aws.appflow.model.ConnectorType]] =
      AwsError.unwrapOptionField(
        "supportedDestinationConnectors",
        supportedDestinationConnectors
      )
    def getSupportedSchedulingFrequencies: ZIO[Any, AwsError, List[
      zio.aws.appflow.model.ScheduleFrequencyType
    ]] = AwsError.unwrapOptionField(
      "supportedSchedulingFrequencies",
      supportedSchedulingFrequencies
    )
    def getIsPrivateLinkEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPrivateLinkEnabled", isPrivateLinkEnabled)
    def getIsPrivateLinkEndpointUrlRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "isPrivateLinkEndpointUrlRequired",
        isPrivateLinkEndpointUrlRequired
      )
    def getSupportedTriggerTypes
        : ZIO[Any, AwsError, List[zio.aws.appflow.model.TriggerType]] =
      AwsError.unwrapOptionField("supportedTriggerTypes", supportedTriggerTypes)
    def getConnectorMetadata
        : ZIO[Any, AwsError, zio.aws.appflow.model.ConnectorMetadata.ReadOnly] =
      AwsError.unwrapOptionField("connectorMetadata", connectorMetadata)
    def getConnectorType
        : ZIO[Any, AwsError, zio.aws.appflow.model.ConnectorType] =
      AwsError.unwrapOptionField("connectorType", connectorType)
    def getConnectorLabel: ZIO[Any, AwsError, ConnectorLabel] =
      AwsError.unwrapOptionField("connectorLabel", connectorLabel)
    def getConnectorDescription: ZIO[Any, AwsError, ConnectorDescription] =
      AwsError.unwrapOptionField("connectorDescription", connectorDescription)
    def getConnectorOwner: ZIO[Any, AwsError, ConnectorOwner] =
      AwsError.unwrapOptionField("connectorOwner", connectorOwner)
    def getConnectorName: ZIO[Any, AwsError, ConnectorName] =
      AwsError.unwrapOptionField("connectorName", connectorName)
    def getConnectorVersion: ZIO[Any, AwsError, ConnectorVersion] =
      AwsError.unwrapOptionField("connectorVersion", connectorVersion)
    def getConnectorArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("connectorArn", connectorArn)
    def getConnectorModes: ZIO[Any, AwsError, List[ConnectorMode]] =
      AwsError.unwrapOptionField("connectorModes", connectorModes)
    def getAuthenticationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.AuthenticationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("authenticationConfig", authenticationConfig)
    def getConnectorRuntimeSettings: ZIO[Any, AwsError, List[
      zio.aws.appflow.model.ConnectorRuntimeSetting.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "connectorRuntimeSettings",
      connectorRuntimeSettings
    )
    def getSupportedApiVersions: ZIO[Any, AwsError, List[SupportedApiVersion]] =
      AwsError.unwrapOptionField("supportedApiVersions", supportedApiVersions)
    def getSupportedOperators
        : ZIO[Any, AwsError, List[zio.aws.appflow.model.Operators]] =
      AwsError.unwrapOptionField("supportedOperators", supportedOperators)
    def getSupportedWriteOperations
        : ZIO[Any, AwsError, List[zio.aws.appflow.model.WriteOperationType]] =
      AwsError.unwrapOptionField(
        "supportedWriteOperations",
        supportedWriteOperations
      )
    def getConnectorProvisioningType
        : ZIO[Any, AwsError, zio.aws.appflow.model.ConnectorProvisioningType] =
      AwsError.unwrapOptionField(
        "connectorProvisioningType",
        connectorProvisioningType
      )
    def getConnectorProvisioningConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ConnectorProvisioningConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "connectorProvisioningConfig",
      connectorProvisioningConfig
    )
    def getLogoURL: ZIO[Any, AwsError, LogoURL] =
      AwsError.unwrapOptionField("logoURL", logoURL)
    def getRegisteredAt: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("registeredAt", registeredAt)
    def getRegisteredBy: ZIO[Any, AwsError, RegisteredBy] =
      AwsError.unwrapOptionField("registeredBy", registeredBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorConfiguration
  ) extends zio.aws.appflow.model.ConnectorConfiguration.ReadOnly {
    override val canUseAsSource: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.canUseAsSource())
      .map(value => value: Boolean)
    override val canUseAsDestination: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.canUseAsDestination())
      .map(value => value: Boolean)
    override val supportedDestinationConnectors
        : Optional[List[zio.aws.appflow.model.ConnectorType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedDestinationConnectors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.ConnectorType.wrap(item)
          }.toList
        )
    override val supportedSchedulingFrequencies
        : Optional[List[zio.aws.appflow.model.ScheduleFrequencyType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedSchedulingFrequencies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.ScheduleFrequencyType.wrap(item)
          }.toList
        )
    override val isPrivateLinkEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isPrivateLinkEnabled())
      .map(value => value: Boolean)
    override val isPrivateLinkEndpointUrlRequired: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isPrivateLinkEndpointUrlRequired())
        .map(value => value: Boolean)
    override val supportedTriggerTypes
        : Optional[List[zio.aws.appflow.model.TriggerType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedTriggerTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.TriggerType.wrap(item)
          }.toList
        )
    override val connectorMetadata
        : Optional[zio.aws.appflow.model.ConnectorMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorMetadata())
        .map(value => zio.aws.appflow.model.ConnectorMetadata.wrap(value))
    override val connectorType: Optional[zio.aws.appflow.model.ConnectorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorType())
        .map(value => zio.aws.appflow.model.ConnectorType.wrap(value))
    override val connectorLabel: Optional[ConnectorLabel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorLabel())
        .map(value => zio.aws.appflow.model.primitives.ConnectorLabel(value))
    override val connectorDescription: Optional[ConnectorDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorDescription())
        .map(value =>
          zio.aws.appflow.model.primitives.ConnectorDescription(value)
        )
    override val connectorOwner: Optional[ConnectorOwner] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorOwner())
        .map(value => zio.aws.appflow.model.primitives.ConnectorOwner(value))
    override val connectorName: Optional[ConnectorName] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorName())
      .map(value => zio.aws.appflow.model.primitives.ConnectorName(value))
    override val connectorVersion: Optional[ConnectorVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorVersion())
        .map(value => zio.aws.appflow.model.primitives.ConnectorVersion(value))
    override val connectorArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorArn())
      .map(value => zio.aws.appflow.model.primitives.ARN(value))
    override val connectorModes: Optional[List[ConnectorMode]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorModes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.primitives.ConnectorMode(item)
          }.toList
        )
    override val authenticationConfig
        : Optional[zio.aws.appflow.model.AuthenticationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationConfig())
        .map(value => zio.aws.appflow.model.AuthenticationConfig.wrap(value))
    override val connectorRuntimeSettings: Optional[
      List[zio.aws.appflow.model.ConnectorRuntimeSetting.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorRuntimeSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appflow.model.ConnectorRuntimeSetting.wrap(item)
        }.toList
      )
    override val supportedApiVersions: Optional[List[SupportedApiVersion]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedApiVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.primitives.SupportedApiVersion(item)
          }.toList
        )
    override val supportedOperators
        : Optional[List[zio.aws.appflow.model.Operators]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedOperators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.Operators.wrap(item)
          }.toList
        )
    override val supportedWriteOperations
        : Optional[List[zio.aws.appflow.model.WriteOperationType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedWriteOperations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.WriteOperationType.wrap(item)
          }.toList
        )
    override val connectorProvisioningType
        : Optional[zio.aws.appflow.model.ConnectorProvisioningType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorProvisioningType())
        .map(value =>
          zio.aws.appflow.model.ConnectorProvisioningType.wrap(value)
        )
    override val connectorProvisioningConfig
        : Optional[zio.aws.appflow.model.ConnectorProvisioningConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorProvisioningConfig())
        .map(value =>
          zio.aws.appflow.model.ConnectorProvisioningConfig.wrap(value)
        )
    override val logoURL: Optional[LogoURL] = zio.aws.core.internal
      .optionalFromNullable(impl.logoURL())
      .map(value => zio.aws.appflow.model.primitives.LogoURL(value))
    override val registeredAt: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.registeredAt())
      .map(value => zio.aws.appflow.model.primitives.Date(value))
    override val registeredBy: Optional[RegisteredBy] = zio.aws.core.internal
      .optionalFromNullable(impl.registeredBy())
      .map(value => zio.aws.appflow.model.primitives.RegisteredBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorConfiguration
  ): zio.aws.appflow.model.ConnectorConfiguration.ReadOnly = new Wrapper(impl)
}
