package zio.aws.appflow.model
import zio.aws.appflow.model.primitives.{
  ConnectorMode,
  Date,
  ConnectorOwner,
  ApplicationType,
  RegisteredBy,
  ConnectorName,
  ConnectorLabel,
  ConnectorDescription,
  ConnectorVersion
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ConnectorDetail(
    connectorDescription: Optional[ConnectorDescription] = Optional.Absent,
    connectorName: Optional[ConnectorName] = Optional.Absent,
    connectorOwner: Optional[ConnectorOwner] = Optional.Absent,
    connectorVersion: Optional[ConnectorVersion] = Optional.Absent,
    applicationType: Optional[ApplicationType] = Optional.Absent,
    connectorType: Optional[zio.aws.appflow.model.ConnectorType] =
      Optional.Absent,
    connectorLabel: Optional[ConnectorLabel] = Optional.Absent,
    registeredAt: Optional[Date] = Optional.Absent,
    registeredBy: Optional[RegisteredBy] = Optional.Absent,
    connectorProvisioningType: Optional[
      zio.aws.appflow.model.ConnectorProvisioningType
    ] = Optional.Absent,
    connectorModes: Optional[Iterable[ConnectorMode]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ConnectorDetail = {
    import ConnectorDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ConnectorDetail
      .builder()
      .optionallyWith(
        connectorDescription.map(value =>
          ConnectorDescription.unwrap(value): java.lang.String
        )
      )(_.connectorDescription)
      .optionallyWith(
        connectorName.map(value =>
          ConnectorName.unwrap(value): java.lang.String
        )
      )(_.connectorName)
      .optionallyWith(
        connectorOwner.map(value =>
          ConnectorOwner.unwrap(value): java.lang.String
        )
      )(_.connectorOwner)
      .optionallyWith(
        connectorVersion.map(value =>
          ConnectorVersion.unwrap(value): java.lang.String
        )
      )(_.connectorVersion)
      .optionallyWith(
        applicationType.map(value =>
          ApplicationType.unwrap(value): java.lang.String
        )
      )(_.applicationType)
      .optionallyWith(connectorType.map(value => value.unwrap))(_.connectorType)
      .optionallyWith(
        connectorLabel.map(value =>
          ConnectorLabel.unwrap(value): java.lang.String
        )
      )(_.connectorLabel)
      .optionallyWith(registeredAt.map(value => Date.unwrap(value): Instant))(
        _.registeredAt
      )
      .optionallyWith(
        registeredBy.map(value => RegisteredBy.unwrap(value): java.lang.String)
      )(_.registeredBy)
      .optionallyWith(connectorProvisioningType.map(value => value.unwrap))(
        _.connectorProvisioningType
      )
      .optionallyWith(
        connectorModes.map(value =>
          value.map { item =>
            ConnectorMode.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.connectorModes)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ConnectorDetail.ReadOnly =
    zio.aws.appflow.model.ConnectorDetail.wrap(buildAwsValue())
}
object ConnectorDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ConnectorDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ConnectorDetail =
      zio.aws.appflow.model.ConnectorDetail(
        connectorDescription.map(value => value),
        connectorName.map(value => value),
        connectorOwner.map(value => value),
        connectorVersion.map(value => value),
        applicationType.map(value => value),
        connectorType.map(value => value),
        connectorLabel.map(value => value),
        registeredAt.map(value => value),
        registeredBy.map(value => value),
        connectorProvisioningType.map(value => value),
        connectorModes.map(value => value)
      )
    def connectorDescription: Optional[ConnectorDescription]
    def connectorName: Optional[ConnectorName]
    def connectorOwner: Optional[ConnectorOwner]
    def connectorVersion: Optional[ConnectorVersion]
    def applicationType: Optional[ApplicationType]
    def connectorType: Optional[zio.aws.appflow.model.ConnectorType]
    def connectorLabel: Optional[ConnectorLabel]
    def registeredAt: Optional[Date]
    def registeredBy: Optional[RegisteredBy]
    def connectorProvisioningType
        : Optional[zio.aws.appflow.model.ConnectorProvisioningType]
    def connectorModes: Optional[List[ConnectorMode]]
    def getConnectorDescription: ZIO[Any, AwsError, ConnectorDescription] =
      AwsError.unwrapOptionField("connectorDescription", connectorDescription)
    def getConnectorName: ZIO[Any, AwsError, ConnectorName] =
      AwsError.unwrapOptionField("connectorName", connectorName)
    def getConnectorOwner: ZIO[Any, AwsError, ConnectorOwner] =
      AwsError.unwrapOptionField("connectorOwner", connectorOwner)
    def getConnectorVersion: ZIO[Any, AwsError, ConnectorVersion] =
      AwsError.unwrapOptionField("connectorVersion", connectorVersion)
    def getApplicationType: ZIO[Any, AwsError, ApplicationType] =
      AwsError.unwrapOptionField("applicationType", applicationType)
    def getConnectorType
        : ZIO[Any, AwsError, zio.aws.appflow.model.ConnectorType] =
      AwsError.unwrapOptionField("connectorType", connectorType)
    def getConnectorLabel: ZIO[Any, AwsError, ConnectorLabel] =
      AwsError.unwrapOptionField("connectorLabel", connectorLabel)
    def getRegisteredAt: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("registeredAt", registeredAt)
    def getRegisteredBy: ZIO[Any, AwsError, RegisteredBy] =
      AwsError.unwrapOptionField("registeredBy", registeredBy)
    def getConnectorProvisioningType
        : ZIO[Any, AwsError, zio.aws.appflow.model.ConnectorProvisioningType] =
      AwsError.unwrapOptionField(
        "connectorProvisioningType",
        connectorProvisioningType
      )
    def getConnectorModes: ZIO[Any, AwsError, List[ConnectorMode]] =
      AwsError.unwrapOptionField("connectorModes", connectorModes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorDetail
  ) extends zio.aws.appflow.model.ConnectorDetail.ReadOnly {
    override val connectorDescription: Optional[ConnectorDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorDescription())
        .map(value =>
          zio.aws.appflow.model.primitives.ConnectorDescription(value)
        )
    override val connectorName: Optional[ConnectorName] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorName())
      .map(value => zio.aws.appflow.model.primitives.ConnectorName(value))
    override val connectorOwner: Optional[ConnectorOwner] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorOwner())
        .map(value => zio.aws.appflow.model.primitives.ConnectorOwner(value))
    override val connectorVersion: Optional[ConnectorVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorVersion())
        .map(value => zio.aws.appflow.model.primitives.ConnectorVersion(value))
    override val applicationType: Optional[ApplicationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationType())
        .map(value => zio.aws.appflow.model.primitives.ApplicationType(value))
    override val connectorType: Optional[zio.aws.appflow.model.ConnectorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorType())
        .map(value => zio.aws.appflow.model.ConnectorType.wrap(value))
    override val connectorLabel: Optional[ConnectorLabel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorLabel())
        .map(value => zio.aws.appflow.model.primitives.ConnectorLabel(value))
    override val registeredAt: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.registeredAt())
      .map(value => zio.aws.appflow.model.primitives.Date(value))
    override val registeredBy: Optional[RegisteredBy] = zio.aws.core.internal
      .optionalFromNullable(impl.registeredBy())
      .map(value => zio.aws.appflow.model.primitives.RegisteredBy(value))
    override val connectorProvisioningType
        : Optional[zio.aws.appflow.model.ConnectorProvisioningType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorProvisioningType())
        .map(value =>
          zio.aws.appflow.model.ConnectorProvisioningType.wrap(value)
        )
    override val connectorModes: Optional[List[ConnectorMode]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorModes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.primitives.ConnectorMode(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorDetail
  ): zio.aws.appflow.model.ConnectorDetail.ReadOnly = new Wrapper(impl)
}
