package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{Label, Name}
import scala.jdk.CollectionConverters.*
final case class ConnectorEntity(
    name: Name,
    label: Optional[Label] = Optional.Absent,
    hasNestedEntities: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ConnectorEntity = {
    import ConnectorEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ConnectorEntity
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        label.map(value => Label.unwrap(value): java.lang.String)
      )(_.label)
      .optionallyWith(hasNestedEntities.map(value => value: java.lang.Boolean))(
        _.hasNestedEntities
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ConnectorEntity.ReadOnly =
    zio.aws.appflow.model.ConnectorEntity.wrap(buildAwsValue())
}
object ConnectorEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ConnectorEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ConnectorEntity =
      zio.aws.appflow.model.ConnectorEntity(
        name,
        label.map(value => value),
        hasNestedEntities.map(value => value)
      )
    def name: Name
    def label: Optional[Label]
    def hasNestedEntities: Optional[Boolean]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getLabel: ZIO[Any, AwsError, Label] =
      AwsError.unwrapOptionField("label", label)
    def getHasNestedEntities: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("hasNestedEntities", hasNestedEntities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorEntity
  ) extends zio.aws.appflow.model.ConnectorEntity.ReadOnly {
    override val name: Name = zio.aws.appflow.model.primitives.Name(impl.name())
    override val label: Optional[Label] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => zio.aws.appflow.model.primitives.Label(value))
    override val hasNestedEntities: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hasNestedEntities())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorEntity
  ): zio.aws.appflow.model.ConnectorEntity.ReadOnly = new Wrapper(impl)
}
