package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{
  Identifier,
  Label,
  CustomPropertyKey,
  Description,
  CustomPropertyValue
}
import scala.jdk.CollectionConverters.*
final case class ConnectorEntityField(
    identifier: Identifier,
    parentIdentifier: Optional[Identifier] = Optional.Absent,
    label: Optional[Label] = Optional.Absent,
    isPrimaryKey: Optional[Boolean] = Optional.Absent,
    defaultValue: Optional[String] = Optional.Absent,
    isDeprecated: Optional[Boolean] = Optional.Absent,
    supportedFieldTypeDetails: Optional[
      zio.aws.appflow.model.SupportedFieldTypeDetails
    ] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    sourceProperties: Optional[zio.aws.appflow.model.SourceFieldProperties] =
      Optional.Absent,
    destinationProperties: Optional[
      zio.aws.appflow.model.DestinationFieldProperties
    ] = Optional.Absent,
    customProperties: Optional[Map[CustomPropertyKey, CustomPropertyValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ConnectorEntityField = {
    import ConnectorEntityField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ConnectorEntityField
      .builder()
      .identifier(Identifier.unwrap(identifier): java.lang.String)
      .optionallyWith(
        parentIdentifier.map(value =>
          Identifier.unwrap(value): java.lang.String
        )
      )(_.parentIdentifier)
      .optionallyWith(
        label.map(value => Label.unwrap(value): java.lang.String)
      )(_.label)
      .optionallyWith(isPrimaryKey.map(value => value: java.lang.Boolean))(
        _.isPrimaryKey
      )
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(isDeprecated.map(value => value: java.lang.Boolean))(
        _.isDeprecated
      )
      .optionallyWith(
        supportedFieldTypeDetails.map(value => value.buildAwsValue())
      )(_.supportedFieldTypeDetails)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(sourceProperties.map(value => value.buildAwsValue()))(
        _.sourceProperties
      )
      .optionallyWith(
        destinationProperties.map(value => value.buildAwsValue())
      )(_.destinationProperties)
      .optionallyWith(
        customProperties.map(value =>
          value
            .map({ case (key, value) =>
              (CustomPropertyKey
                .unwrap(key): java.lang.String) -> (CustomPropertyValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.customProperties)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ConnectorEntityField.ReadOnly =
    zio.aws.appflow.model.ConnectorEntityField.wrap(buildAwsValue())
}
object ConnectorEntityField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ConnectorEntityField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ConnectorEntityField =
      zio.aws.appflow.model.ConnectorEntityField(
        identifier,
        parentIdentifier.map(value => value),
        label.map(value => value),
        isPrimaryKey.map(value => value),
        defaultValue.map(value => value),
        isDeprecated.map(value => value),
        supportedFieldTypeDetails.map(value => value.asEditable),
        description.map(value => value),
        sourceProperties.map(value => value.asEditable),
        destinationProperties.map(value => value.asEditable),
        customProperties.map(value => value)
      )
    def identifier: Identifier
    def parentIdentifier: Optional[Identifier]
    def label: Optional[Label]
    def isPrimaryKey: Optional[Boolean]
    def defaultValue: Optional[String]
    def isDeprecated: Optional[Boolean]
    def supportedFieldTypeDetails
        : Optional[zio.aws.appflow.model.SupportedFieldTypeDetails.ReadOnly]
    def description: Optional[Description]
    def sourceProperties
        : Optional[zio.aws.appflow.model.SourceFieldProperties.ReadOnly]
    def destinationProperties
        : Optional[zio.aws.appflow.model.DestinationFieldProperties.ReadOnly]
    def customProperties: Optional[Map[CustomPropertyKey, CustomPropertyValue]]
    def getIdentifier: ZIO[Any, Nothing, Identifier] = ZIO.succeed(identifier)
    def getParentIdentifier: ZIO[Any, AwsError, Identifier] =
      AwsError.unwrapOptionField("parentIdentifier", parentIdentifier)
    def getLabel: ZIO[Any, AwsError, Label] =
      AwsError.unwrapOptionField("label", label)
    def getIsPrimaryKey: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPrimaryKey", isPrimaryKey)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getIsDeprecated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDeprecated", isDeprecated)
    def getSupportedFieldTypeDetails: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SupportedFieldTypeDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "supportedFieldTypeDetails",
      supportedFieldTypeDetails
    )
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSourceProperties: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SourceFieldProperties.ReadOnly
    ] = AwsError.unwrapOptionField("sourceProperties", sourceProperties)
    def getDestinationProperties: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.DestinationFieldProperties.ReadOnly
    ] =
      AwsError.unwrapOptionField("destinationProperties", destinationProperties)
    def getCustomProperties
        : ZIO[Any, AwsError, Map[CustomPropertyKey, CustomPropertyValue]] =
      AwsError.unwrapOptionField("customProperties", customProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorEntityField
  ) extends zio.aws.appflow.model.ConnectorEntityField.ReadOnly {
    override val identifier: Identifier =
      zio.aws.appflow.model.primitives.Identifier(impl.identifier())
    override val parentIdentifier: Optional[Identifier] = zio.aws.core.internal
      .optionalFromNullable(impl.parentIdentifier())
      .map(value => zio.aws.appflow.model.primitives.Identifier(value))
    override val label: Optional[Label] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => zio.aws.appflow.model.primitives.Label(value))
    override val isPrimaryKey: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isPrimaryKey())
      .map(value => value: Boolean)
    override val defaultValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value => value: String)
    override val isDeprecated: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDeprecated())
      .map(value => value: Boolean)
    override val supportedFieldTypeDetails
        : Optional[zio.aws.appflow.model.SupportedFieldTypeDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedFieldTypeDetails())
        .map(value =>
          zio.aws.appflow.model.SupportedFieldTypeDetails.wrap(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appflow.model.primitives.Description(value))
    override val sourceProperties
        : Optional[zio.aws.appflow.model.SourceFieldProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceProperties())
        .map(value => zio.aws.appflow.model.SourceFieldProperties.wrap(value))
    override val destinationProperties
        : Optional[zio.aws.appflow.model.DestinationFieldProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationProperties())
        .map(value =>
          zio.aws.appflow.model.DestinationFieldProperties.wrap(value)
        )
    override val customProperties
        : Optional[Map[CustomPropertyKey, CustomPropertyValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customProperties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.appflow.model.primitives.CustomPropertyKey(
                key
              ) -> zio.aws.appflow.model.primitives.CustomPropertyValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorEntityField
  ): zio.aws.appflow.model.ConnectorEntityField.ReadOnly = new Wrapper(impl)
}
