package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConnectorMetadata(
    amplitude: Optional[zio.aws.appflow.model.AmplitudeMetadata] =
      Optional.Absent,
    datadog: Optional[zio.aws.appflow.model.DatadogMetadata] = Optional.Absent,
    dynatrace: Optional[zio.aws.appflow.model.DynatraceMetadata] =
      Optional.Absent,
    googleAnalytics: Optional[zio.aws.appflow.model.GoogleAnalyticsMetadata] =
      Optional.Absent,
    inforNexus: Optional[zio.aws.appflow.model.InforNexusMetadata] =
      Optional.Absent,
    marketo: Optional[zio.aws.appflow.model.MarketoMetadata] = Optional.Absent,
    redshift: Optional[zio.aws.appflow.model.RedshiftMetadata] =
      Optional.Absent,
    s3: Optional[zio.aws.appflow.model.S3Metadata] = Optional.Absent,
    salesforce: Optional[zio.aws.appflow.model.SalesforceMetadata] =
      Optional.Absent,
    serviceNow: Optional[zio.aws.appflow.model.ServiceNowMetadata] =
      Optional.Absent,
    singular: Optional[zio.aws.appflow.model.SingularMetadata] =
      Optional.Absent,
    slack: Optional[zio.aws.appflow.model.SlackMetadata] = Optional.Absent,
    snowflake: Optional[zio.aws.appflow.model.SnowflakeMetadata] =
      Optional.Absent,
    trendmicro: Optional[zio.aws.appflow.model.TrendmicroMetadata] =
      Optional.Absent,
    veeva: Optional[zio.aws.appflow.model.VeevaMetadata] = Optional.Absent,
    zendesk: Optional[zio.aws.appflow.model.ZendeskMetadata] = Optional.Absent,
    eventBridge: Optional[zio.aws.appflow.model.EventBridgeMetadata] =
      Optional.Absent,
    upsolver: Optional[zio.aws.appflow.model.UpsolverMetadata] =
      Optional.Absent,
    customerProfiles: Optional[zio.aws.appflow.model.CustomerProfilesMetadata] =
      Optional.Absent,
    honeycode: Optional[zio.aws.appflow.model.HoneycodeMetadata] =
      Optional.Absent,
    sapoData: Optional[zio.aws.appflow.model.SAPODataMetadata] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ConnectorMetadata = {
    import ConnectorMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ConnectorMetadata
      .builder()
      .optionallyWith(amplitude.map(value => value.buildAwsValue()))(
        _.amplitude
      )
      .optionallyWith(datadog.map(value => value.buildAwsValue()))(_.datadog)
      .optionallyWith(dynatrace.map(value => value.buildAwsValue()))(
        _.dynatrace
      )
      .optionallyWith(googleAnalytics.map(value => value.buildAwsValue()))(
        _.googleAnalytics
      )
      .optionallyWith(inforNexus.map(value => value.buildAwsValue()))(
        _.inforNexus
      )
      .optionallyWith(marketo.map(value => value.buildAwsValue()))(_.marketo)
      .optionallyWith(redshift.map(value => value.buildAwsValue()))(_.redshift)
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .optionallyWith(salesforce.map(value => value.buildAwsValue()))(
        _.salesforce
      )
      .optionallyWith(serviceNow.map(value => value.buildAwsValue()))(
        _.serviceNow
      )
      .optionallyWith(singular.map(value => value.buildAwsValue()))(_.singular)
      .optionallyWith(slack.map(value => value.buildAwsValue()))(_.slack)
      .optionallyWith(snowflake.map(value => value.buildAwsValue()))(
        _.snowflake
      )
      .optionallyWith(trendmicro.map(value => value.buildAwsValue()))(
        _.trendmicro
      )
      .optionallyWith(veeva.map(value => value.buildAwsValue()))(_.veeva)
      .optionallyWith(zendesk.map(value => value.buildAwsValue()))(_.zendesk)
      .optionallyWith(eventBridge.map(value => value.buildAwsValue()))(
        _.eventBridge
      )
      .optionallyWith(upsolver.map(value => value.buildAwsValue()))(_.upsolver)
      .optionallyWith(customerProfiles.map(value => value.buildAwsValue()))(
        _.customerProfiles
      )
      .optionallyWith(honeycode.map(value => value.buildAwsValue()))(
        _.honeycode
      )
      .optionallyWith(sapoData.map(value => value.buildAwsValue()))(_.sapoData)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ConnectorMetadata.ReadOnly =
    zio.aws.appflow.model.ConnectorMetadata.wrap(buildAwsValue())
}
object ConnectorMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ConnectorMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ConnectorMetadata =
      zio.aws.appflow.model.ConnectorMetadata(
        amplitude.map(value => value.asEditable),
        datadog.map(value => value.asEditable),
        dynatrace.map(value => value.asEditable),
        googleAnalytics.map(value => value.asEditable),
        inforNexus.map(value => value.asEditable),
        marketo.map(value => value.asEditable),
        redshift.map(value => value.asEditable),
        s3.map(value => value.asEditable),
        salesforce.map(value => value.asEditable),
        serviceNow.map(value => value.asEditable),
        singular.map(value => value.asEditable),
        slack.map(value => value.asEditable),
        snowflake.map(value => value.asEditable),
        trendmicro.map(value => value.asEditable),
        veeva.map(value => value.asEditable),
        zendesk.map(value => value.asEditable),
        eventBridge.map(value => value.asEditable),
        upsolver.map(value => value.asEditable),
        customerProfiles.map(value => value.asEditable),
        honeycode.map(value => value.asEditable),
        sapoData.map(value => value.asEditable)
      )
    def amplitude: Optional[zio.aws.appflow.model.AmplitudeMetadata.ReadOnly]
    def datadog: Optional[zio.aws.appflow.model.DatadogMetadata.ReadOnly]
    def dynatrace: Optional[zio.aws.appflow.model.DynatraceMetadata.ReadOnly]
    def googleAnalytics
        : Optional[zio.aws.appflow.model.GoogleAnalyticsMetadata.ReadOnly]
    def inforNexus: Optional[zio.aws.appflow.model.InforNexusMetadata.ReadOnly]
    def marketo: Optional[zio.aws.appflow.model.MarketoMetadata.ReadOnly]
    def redshift: Optional[zio.aws.appflow.model.RedshiftMetadata.ReadOnly]
    def s3: Optional[zio.aws.appflow.model.S3Metadata.ReadOnly]
    def salesforce: Optional[zio.aws.appflow.model.SalesforceMetadata.ReadOnly]
    def serviceNow: Optional[zio.aws.appflow.model.ServiceNowMetadata.ReadOnly]
    def singular: Optional[zio.aws.appflow.model.SingularMetadata.ReadOnly]
    def slack: Optional[zio.aws.appflow.model.SlackMetadata.ReadOnly]
    def snowflake: Optional[zio.aws.appflow.model.SnowflakeMetadata.ReadOnly]
    def trendmicro: Optional[zio.aws.appflow.model.TrendmicroMetadata.ReadOnly]
    def veeva: Optional[zio.aws.appflow.model.VeevaMetadata.ReadOnly]
    def zendesk: Optional[zio.aws.appflow.model.ZendeskMetadata.ReadOnly]
    def eventBridge
        : Optional[zio.aws.appflow.model.EventBridgeMetadata.ReadOnly]
    def upsolver: Optional[zio.aws.appflow.model.UpsolverMetadata.ReadOnly]
    def customerProfiles
        : Optional[zio.aws.appflow.model.CustomerProfilesMetadata.ReadOnly]
    def honeycode: Optional[zio.aws.appflow.model.HoneycodeMetadata.ReadOnly]
    def sapoData: Optional[zio.aws.appflow.model.SAPODataMetadata.ReadOnly]
    def getAmplitude
        : ZIO[Any, AwsError, zio.aws.appflow.model.AmplitudeMetadata.ReadOnly] =
      AwsError.unwrapOptionField("amplitude", amplitude)
    def getDatadog
        : ZIO[Any, AwsError, zio.aws.appflow.model.DatadogMetadata.ReadOnly] =
      AwsError.unwrapOptionField("datadog", datadog)
    def getDynatrace
        : ZIO[Any, AwsError, zio.aws.appflow.model.DynatraceMetadata.ReadOnly] =
      AwsError.unwrapOptionField("dynatrace", dynatrace)
    def getGoogleAnalytics: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.GoogleAnalyticsMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("googleAnalytics", googleAnalytics)
    def getInforNexus: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.InforNexusMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("inforNexus", inforNexus)
    def getMarketo
        : ZIO[Any, AwsError, zio.aws.appflow.model.MarketoMetadata.ReadOnly] =
      AwsError.unwrapOptionField("marketo", marketo)
    def getRedshift
        : ZIO[Any, AwsError, zio.aws.appflow.model.RedshiftMetadata.ReadOnly] =
      AwsError.unwrapOptionField("redshift", redshift)
    def getS3: ZIO[Any, AwsError, zio.aws.appflow.model.S3Metadata.ReadOnly] =
      AwsError.unwrapOptionField("s3", s3)
    def getSalesforce: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SalesforceMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("salesforce", salesforce)
    def getServiceNow: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ServiceNowMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("serviceNow", serviceNow)
    def getSingular
        : ZIO[Any, AwsError, zio.aws.appflow.model.SingularMetadata.ReadOnly] =
      AwsError.unwrapOptionField("singular", singular)
    def getSlack
        : ZIO[Any, AwsError, zio.aws.appflow.model.SlackMetadata.ReadOnly] =
      AwsError.unwrapOptionField("slack", slack)
    def getSnowflake
        : ZIO[Any, AwsError, zio.aws.appflow.model.SnowflakeMetadata.ReadOnly] =
      AwsError.unwrapOptionField("snowflake", snowflake)
    def getTrendmicro: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.TrendmicroMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("trendmicro", trendmicro)
    def getVeeva
        : ZIO[Any, AwsError, zio.aws.appflow.model.VeevaMetadata.ReadOnly] =
      AwsError.unwrapOptionField("veeva", veeva)
    def getZendesk
        : ZIO[Any, AwsError, zio.aws.appflow.model.ZendeskMetadata.ReadOnly] =
      AwsError.unwrapOptionField("zendesk", zendesk)
    def getEventBridge: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.EventBridgeMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("eventBridge", eventBridge)
    def getUpsolver
        : ZIO[Any, AwsError, zio.aws.appflow.model.UpsolverMetadata.ReadOnly] =
      AwsError.unwrapOptionField("upsolver", upsolver)
    def getCustomerProfiles: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.CustomerProfilesMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("customerProfiles", customerProfiles)
    def getHoneycode
        : ZIO[Any, AwsError, zio.aws.appflow.model.HoneycodeMetadata.ReadOnly] =
      AwsError.unwrapOptionField("honeycode", honeycode)
    def getSapoData
        : ZIO[Any, AwsError, zio.aws.appflow.model.SAPODataMetadata.ReadOnly] =
      AwsError.unwrapOptionField("sapoData", sapoData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorMetadata
  ) extends zio.aws.appflow.model.ConnectorMetadata.ReadOnly {
    override val amplitude
        : Optional[zio.aws.appflow.model.AmplitudeMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.amplitude())
        .map(value => zio.aws.appflow.model.AmplitudeMetadata.wrap(value))
    override val datadog
        : Optional[zio.aws.appflow.model.DatadogMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datadog())
        .map(value => zio.aws.appflow.model.DatadogMetadata.wrap(value))
    override val dynatrace
        : Optional[zio.aws.appflow.model.DynatraceMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dynatrace())
        .map(value => zio.aws.appflow.model.DynatraceMetadata.wrap(value))
    override val googleAnalytics
        : Optional[zio.aws.appflow.model.GoogleAnalyticsMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.googleAnalytics())
        .map(value => zio.aws.appflow.model.GoogleAnalyticsMetadata.wrap(value))
    override val inforNexus
        : Optional[zio.aws.appflow.model.InforNexusMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inforNexus())
        .map(value => zio.aws.appflow.model.InforNexusMetadata.wrap(value))
    override val marketo
        : Optional[zio.aws.appflow.model.MarketoMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.marketo())
        .map(value => zio.aws.appflow.model.MarketoMetadata.wrap(value))
    override val redshift
        : Optional[zio.aws.appflow.model.RedshiftMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redshift())
        .map(value => zio.aws.appflow.model.RedshiftMetadata.wrap(value))
    override val s3: Optional[zio.aws.appflow.model.S3Metadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value => zio.aws.appflow.model.S3Metadata.wrap(value))
    override val salesforce
        : Optional[zio.aws.appflow.model.SalesforceMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.salesforce())
        .map(value => zio.aws.appflow.model.SalesforceMetadata.wrap(value))
    override val serviceNow
        : Optional[zio.aws.appflow.model.ServiceNowMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceNow())
        .map(value => zio.aws.appflow.model.ServiceNowMetadata.wrap(value))
    override val singular
        : Optional[zio.aws.appflow.model.SingularMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.singular())
        .map(value => zio.aws.appflow.model.SingularMetadata.wrap(value))
    override val slack: Optional[zio.aws.appflow.model.SlackMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slack())
        .map(value => zio.aws.appflow.model.SlackMetadata.wrap(value))
    override val snowflake
        : Optional[zio.aws.appflow.model.SnowflakeMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snowflake())
        .map(value => zio.aws.appflow.model.SnowflakeMetadata.wrap(value))
    override val trendmicro
        : Optional[zio.aws.appflow.model.TrendmicroMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trendmicro())
        .map(value => zio.aws.appflow.model.TrendmicroMetadata.wrap(value))
    override val veeva: Optional[zio.aws.appflow.model.VeevaMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.veeva())
        .map(value => zio.aws.appflow.model.VeevaMetadata.wrap(value))
    override val zendesk
        : Optional[zio.aws.appflow.model.ZendeskMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.zendesk())
        .map(value => zio.aws.appflow.model.ZendeskMetadata.wrap(value))
    override val eventBridge
        : Optional[zio.aws.appflow.model.EventBridgeMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBridge())
        .map(value => zio.aws.appflow.model.EventBridgeMetadata.wrap(value))
    override val upsolver
        : Optional[zio.aws.appflow.model.UpsolverMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.upsolver())
        .map(value => zio.aws.appflow.model.UpsolverMetadata.wrap(value))
    override val customerProfiles
        : Optional[zio.aws.appflow.model.CustomerProfilesMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerProfiles())
        .map(value =>
          zio.aws.appflow.model.CustomerProfilesMetadata.wrap(value)
        )
    override val honeycode
        : Optional[zio.aws.appflow.model.HoneycodeMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.honeycode())
        .map(value => zio.aws.appflow.model.HoneycodeMetadata.wrap(value))
    override val sapoData
        : Optional[zio.aws.appflow.model.SAPODataMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sapoData())
        .map(value => zio.aws.appflow.model.SAPODataMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorMetadata
  ): zio.aws.appflow.model.ConnectorMetadata.ReadOnly = new Wrapper(impl)
}
