package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{RedirectUri, AuthCode}
import scala.jdk.CollectionConverters.*
final case class ConnectorOAuthRequest(
    authCode: Optional[AuthCode] = Optional.Absent,
    redirectUri: Optional[RedirectUri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ConnectorOAuthRequest = {
    import ConnectorOAuthRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ConnectorOAuthRequest
      .builder()
      .optionallyWith(
        authCode.map(value => AuthCode.unwrap(value): java.lang.String)
      )(_.authCode)
      .optionallyWith(
        redirectUri.map(value => RedirectUri.unwrap(value): java.lang.String)
      )(_.redirectUri)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly =
    zio.aws.appflow.model.ConnectorOAuthRequest.wrap(buildAwsValue())
}
object ConnectorOAuthRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ConnectorOAuthRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ConnectorOAuthRequest =
      zio.aws.appflow.model.ConnectorOAuthRequest(
        authCode.map(value => value),
        redirectUri.map(value => value)
      )
    def authCode: Optional[AuthCode]
    def redirectUri: Optional[RedirectUri]
    def getAuthCode: ZIO[Any, AwsError, AuthCode] =
      AwsError.unwrapOptionField("authCode", authCode)
    def getRedirectUri: ZIO[Any, AwsError, RedirectUri] =
      AwsError.unwrapOptionField("redirectUri", redirectUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorOAuthRequest
  ) extends zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly {
    override val authCode: Optional[AuthCode] = zio.aws.core.internal
      .optionalFromNullable(impl.authCode())
      .map(value => zio.aws.appflow.model.primitives.AuthCode(value))
    override val redirectUri: Optional[RedirectUri] = zio.aws.core.internal
      .optionalFromNullable(impl.redirectUri())
      .map(value => zio.aws.appflow.model.primitives.RedirectUri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorOAuthRequest
  ): zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly = new Wrapper(impl)
}
