package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConnectorOperator(
    amplitude: Optional[zio.aws.appflow.model.AmplitudeConnectorOperator] =
      Optional.Absent,
    datadog: Optional[zio.aws.appflow.model.DatadogConnectorOperator] =
      Optional.Absent,
    dynatrace: Optional[zio.aws.appflow.model.DynatraceConnectorOperator] =
      Optional.Absent,
    googleAnalytics: Optional[
      zio.aws.appflow.model.GoogleAnalyticsConnectorOperator
    ] = Optional.Absent,
    inforNexus: Optional[zio.aws.appflow.model.InforNexusConnectorOperator] =
      Optional.Absent,
    marketo: Optional[zio.aws.appflow.model.MarketoConnectorOperator] =
      Optional.Absent,
    s3: Optional[zio.aws.appflow.model.S3ConnectorOperator] = Optional.Absent,
    salesforce: Optional[zio.aws.appflow.model.SalesforceConnectorOperator] =
      Optional.Absent,
    serviceNow: Optional[zio.aws.appflow.model.ServiceNowConnectorOperator] =
      Optional.Absent,
    singular: Optional[zio.aws.appflow.model.SingularConnectorOperator] =
      Optional.Absent,
    slack: Optional[zio.aws.appflow.model.SlackConnectorOperator] =
      Optional.Absent,
    trendmicro: Optional[zio.aws.appflow.model.TrendmicroConnectorOperator] =
      Optional.Absent,
    veeva: Optional[zio.aws.appflow.model.VeevaConnectorOperator] =
      Optional.Absent,
    zendesk: Optional[zio.aws.appflow.model.ZendeskConnectorOperator] =
      Optional.Absent,
    sapoData: Optional[zio.aws.appflow.model.SAPODataConnectorOperator] =
      Optional.Absent,
    customConnector: Optional[zio.aws.appflow.model.Operator] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ConnectorOperator = {
    import ConnectorOperator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ConnectorOperator
      .builder()
      .optionallyWith(amplitude.map(value => value.unwrap))(_.amplitude)
      .optionallyWith(datadog.map(value => value.unwrap))(_.datadog)
      .optionallyWith(dynatrace.map(value => value.unwrap))(_.dynatrace)
      .optionallyWith(googleAnalytics.map(value => value.unwrap))(
        _.googleAnalytics
      )
      .optionallyWith(inforNexus.map(value => value.unwrap))(_.inforNexus)
      .optionallyWith(marketo.map(value => value.unwrap))(_.marketo)
      .optionallyWith(s3.map(value => value.unwrap))(_.s3)
      .optionallyWith(salesforce.map(value => value.unwrap))(_.salesforce)
      .optionallyWith(serviceNow.map(value => value.unwrap))(_.serviceNow)
      .optionallyWith(singular.map(value => value.unwrap))(_.singular)
      .optionallyWith(slack.map(value => value.unwrap))(_.slack)
      .optionallyWith(trendmicro.map(value => value.unwrap))(_.trendmicro)
      .optionallyWith(veeva.map(value => value.unwrap))(_.veeva)
      .optionallyWith(zendesk.map(value => value.unwrap))(_.zendesk)
      .optionallyWith(sapoData.map(value => value.unwrap))(_.sapoData)
      .optionallyWith(customConnector.map(value => value.unwrap))(
        _.customConnector
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ConnectorOperator.ReadOnly =
    zio.aws.appflow.model.ConnectorOperator.wrap(buildAwsValue())
}
object ConnectorOperator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ConnectorOperator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ConnectorOperator =
      zio.aws.appflow.model.ConnectorOperator(
        amplitude.map(value => value),
        datadog.map(value => value),
        dynatrace.map(value => value),
        googleAnalytics.map(value => value),
        inforNexus.map(value => value),
        marketo.map(value => value),
        s3.map(value => value),
        salesforce.map(value => value),
        serviceNow.map(value => value),
        singular.map(value => value),
        slack.map(value => value),
        trendmicro.map(value => value),
        veeva.map(value => value),
        zendesk.map(value => value),
        sapoData.map(value => value),
        customConnector.map(value => value)
      )
    def amplitude: Optional[zio.aws.appflow.model.AmplitudeConnectorOperator]
    def datadog: Optional[zio.aws.appflow.model.DatadogConnectorOperator]
    def dynatrace: Optional[zio.aws.appflow.model.DynatraceConnectorOperator]
    def googleAnalytics
        : Optional[zio.aws.appflow.model.GoogleAnalyticsConnectorOperator]
    def inforNexus: Optional[zio.aws.appflow.model.InforNexusConnectorOperator]
    def marketo: Optional[zio.aws.appflow.model.MarketoConnectorOperator]
    def s3: Optional[zio.aws.appflow.model.S3ConnectorOperator]
    def salesforce: Optional[zio.aws.appflow.model.SalesforceConnectorOperator]
    def serviceNow: Optional[zio.aws.appflow.model.ServiceNowConnectorOperator]
    def singular: Optional[zio.aws.appflow.model.SingularConnectorOperator]
    def slack: Optional[zio.aws.appflow.model.SlackConnectorOperator]
    def trendmicro: Optional[zio.aws.appflow.model.TrendmicroConnectorOperator]
    def veeva: Optional[zio.aws.appflow.model.VeevaConnectorOperator]
    def zendesk: Optional[zio.aws.appflow.model.ZendeskConnectorOperator]
    def sapoData: Optional[zio.aws.appflow.model.SAPODataConnectorOperator]
    def customConnector: Optional[zio.aws.appflow.model.Operator]
    def getAmplitude
        : ZIO[Any, AwsError, zio.aws.appflow.model.AmplitudeConnectorOperator] =
      AwsError.unwrapOptionField("amplitude", amplitude)
    def getDatadog
        : ZIO[Any, AwsError, zio.aws.appflow.model.DatadogConnectorOperator] =
      AwsError.unwrapOptionField("datadog", datadog)
    def getDynatrace
        : ZIO[Any, AwsError, zio.aws.appflow.model.DynatraceConnectorOperator] =
      AwsError.unwrapOptionField("dynatrace", dynatrace)
    def getGoogleAnalytics: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.GoogleAnalyticsConnectorOperator
    ] = AwsError.unwrapOptionField("googleAnalytics", googleAnalytics)
    def getInforNexus: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.InforNexusConnectorOperator
    ] = AwsError.unwrapOptionField("inforNexus", inforNexus)
    def getMarketo
        : ZIO[Any, AwsError, zio.aws.appflow.model.MarketoConnectorOperator] =
      AwsError.unwrapOptionField("marketo", marketo)
    def getS3: ZIO[Any, AwsError, zio.aws.appflow.model.S3ConnectorOperator] =
      AwsError.unwrapOptionField("s3", s3)
    def getSalesforce: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SalesforceConnectorOperator
    ] = AwsError.unwrapOptionField("salesforce", salesforce)
    def getServiceNow: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ServiceNowConnectorOperator
    ] = AwsError.unwrapOptionField("serviceNow", serviceNow)
    def getSingular
        : ZIO[Any, AwsError, zio.aws.appflow.model.SingularConnectorOperator] =
      AwsError.unwrapOptionField("singular", singular)
    def getSlack
        : ZIO[Any, AwsError, zio.aws.appflow.model.SlackConnectorOperator] =
      AwsError.unwrapOptionField("slack", slack)
    def getTrendmicro: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.TrendmicroConnectorOperator
    ] = AwsError.unwrapOptionField("trendmicro", trendmicro)
    def getVeeva
        : ZIO[Any, AwsError, zio.aws.appflow.model.VeevaConnectorOperator] =
      AwsError.unwrapOptionField("veeva", veeva)
    def getZendesk
        : ZIO[Any, AwsError, zio.aws.appflow.model.ZendeskConnectorOperator] =
      AwsError.unwrapOptionField("zendesk", zendesk)
    def getSapoData
        : ZIO[Any, AwsError, zio.aws.appflow.model.SAPODataConnectorOperator] =
      AwsError.unwrapOptionField("sapoData", sapoData)
    def getCustomConnector: ZIO[Any, AwsError, zio.aws.appflow.model.Operator] =
      AwsError.unwrapOptionField("customConnector", customConnector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorOperator
  ) extends zio.aws.appflow.model.ConnectorOperator.ReadOnly {
    override val amplitude
        : Optional[zio.aws.appflow.model.AmplitudeConnectorOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.amplitude())
        .map(value =>
          zio.aws.appflow.model.AmplitudeConnectorOperator.wrap(value)
        )
    override val datadog
        : Optional[zio.aws.appflow.model.DatadogConnectorOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datadog())
        .map(value =>
          zio.aws.appflow.model.DatadogConnectorOperator.wrap(value)
        )
    override val dynatrace
        : Optional[zio.aws.appflow.model.DynatraceConnectorOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dynatrace())
        .map(value =>
          zio.aws.appflow.model.DynatraceConnectorOperator.wrap(value)
        )
    override val googleAnalytics
        : Optional[zio.aws.appflow.model.GoogleAnalyticsConnectorOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.googleAnalytics())
        .map(value =>
          zio.aws.appflow.model.GoogleAnalyticsConnectorOperator.wrap(value)
        )
    override val inforNexus
        : Optional[zio.aws.appflow.model.InforNexusConnectorOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inforNexus())
        .map(value =>
          zio.aws.appflow.model.InforNexusConnectorOperator.wrap(value)
        )
    override val marketo
        : Optional[zio.aws.appflow.model.MarketoConnectorOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.marketo())
        .map(value =>
          zio.aws.appflow.model.MarketoConnectorOperator.wrap(value)
        )
    override val s3: Optional[zio.aws.appflow.model.S3ConnectorOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value => zio.aws.appflow.model.S3ConnectorOperator.wrap(value))
    override val salesforce
        : Optional[zio.aws.appflow.model.SalesforceConnectorOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.salesforce())
        .map(value =>
          zio.aws.appflow.model.SalesforceConnectorOperator.wrap(value)
        )
    override val serviceNow
        : Optional[zio.aws.appflow.model.ServiceNowConnectorOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceNow())
        .map(value =>
          zio.aws.appflow.model.ServiceNowConnectorOperator.wrap(value)
        )
    override val singular
        : Optional[zio.aws.appflow.model.SingularConnectorOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.singular())
        .map(value =>
          zio.aws.appflow.model.SingularConnectorOperator.wrap(value)
        )
    override val slack: Optional[zio.aws.appflow.model.SlackConnectorOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slack())
        .map(value => zio.aws.appflow.model.SlackConnectorOperator.wrap(value))
    override val trendmicro
        : Optional[zio.aws.appflow.model.TrendmicroConnectorOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trendmicro())
        .map(value =>
          zio.aws.appflow.model.TrendmicroConnectorOperator.wrap(value)
        )
    override val veeva: Optional[zio.aws.appflow.model.VeevaConnectorOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.veeva())
        .map(value => zio.aws.appflow.model.VeevaConnectorOperator.wrap(value))
    override val zendesk
        : Optional[zio.aws.appflow.model.ZendeskConnectorOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.zendesk())
        .map(value =>
          zio.aws.appflow.model.ZendeskConnectorOperator.wrap(value)
        )
    override val sapoData
        : Optional[zio.aws.appflow.model.SAPODataConnectorOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sapoData())
        .map(value =>
          zio.aws.appflow.model.SAPODataConnectorOperator.wrap(value)
        )
    override val customConnector: Optional[zio.aws.appflow.model.Operator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customConnector())
        .map(value => zio.aws.appflow.model.Operator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorOperator
  ): zio.aws.appflow.model.ConnectorOperator.ReadOnly = new Wrapper(impl)
}
