package zio.aws.appflow.model
import zio.aws.appflow.model.primitives.{
  Date,
  ConnectorProfileArn,
  ConnectorLabel,
  ConnectorProfileName,
  ARN
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ConnectorProfile(
    connectorProfileArn: Optional[ConnectorProfileArn] = Optional.Absent,
    connectorProfileName: Optional[ConnectorProfileName] = Optional.Absent,
    connectorType: Optional[zio.aws.appflow.model.ConnectorType] =
      Optional.Absent,
    connectorLabel: Optional[ConnectorLabel] = Optional.Absent,
    connectionMode: Optional[zio.aws.appflow.model.ConnectionMode] =
      Optional.Absent,
    credentialsArn: Optional[ARN] = Optional.Absent,
    connectorProfileProperties: Optional[
      zio.aws.appflow.model.ConnectorProfileProperties
    ] = Optional.Absent,
    createdAt: Optional[Date] = Optional.Absent,
    lastUpdatedAt: Optional[Date] = Optional.Absent,
    privateConnectionProvisioningState: Optional[
      zio.aws.appflow.model.PrivateConnectionProvisioningState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ConnectorProfile = {
    import ConnectorProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ConnectorProfile
      .builder()
      .optionallyWith(
        connectorProfileArn.map(value =>
          ConnectorProfileArn.unwrap(value): java.lang.String
        )
      )(_.connectorProfileArn)
      .optionallyWith(
        connectorProfileName.map(value =>
          ConnectorProfileName.unwrap(value): java.lang.String
        )
      )(_.connectorProfileName)
      .optionallyWith(connectorType.map(value => value.unwrap))(_.connectorType)
      .optionallyWith(
        connectorLabel.map(value =>
          ConnectorLabel.unwrap(value): java.lang.String
        )
      )(_.connectorLabel)
      .optionallyWith(connectionMode.map(value => value.unwrap))(
        _.connectionMode
      )
      .optionallyWith(
        credentialsArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.credentialsArn)
      .optionallyWith(
        connectorProfileProperties.map(value => value.buildAwsValue())
      )(_.connectorProfileProperties)
      .optionallyWith(createdAt.map(value => Date.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(lastUpdatedAt.map(value => Date.unwrap(value): Instant))(
        _.lastUpdatedAt
      )
      .optionallyWith(
        privateConnectionProvisioningState.map(value => value.buildAwsValue())
      )(_.privateConnectionProvisioningState)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ConnectorProfile.ReadOnly =
    zio.aws.appflow.model.ConnectorProfile.wrap(buildAwsValue())
}
object ConnectorProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ConnectorProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ConnectorProfile =
      zio.aws.appflow.model.ConnectorProfile(
        connectorProfileArn.map(value => value),
        connectorProfileName.map(value => value),
        connectorType.map(value => value),
        connectorLabel.map(value => value),
        connectionMode.map(value => value),
        credentialsArn.map(value => value),
        connectorProfileProperties.map(value => value.asEditable),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        privateConnectionProvisioningState.map(value => value.asEditable)
      )
    def connectorProfileArn: Optional[ConnectorProfileArn]
    def connectorProfileName: Optional[ConnectorProfileName]
    def connectorType: Optional[zio.aws.appflow.model.ConnectorType]
    def connectorLabel: Optional[ConnectorLabel]
    def connectionMode: Optional[zio.aws.appflow.model.ConnectionMode]
    def credentialsArn: Optional[ARN]
    def connectorProfileProperties
        : Optional[zio.aws.appflow.model.ConnectorProfileProperties.ReadOnly]
    def createdAt: Optional[Date]
    def lastUpdatedAt: Optional[Date]
    def privateConnectionProvisioningState: Optional[
      zio.aws.appflow.model.PrivateConnectionProvisioningState.ReadOnly
    ]
    def getConnectorProfileArn: ZIO[Any, AwsError, ConnectorProfileArn] =
      AwsError.unwrapOptionField("connectorProfileArn", connectorProfileArn)
    def getConnectorProfileName: ZIO[Any, AwsError, ConnectorProfileName] =
      AwsError.unwrapOptionField("connectorProfileName", connectorProfileName)
    def getConnectorType
        : ZIO[Any, AwsError, zio.aws.appflow.model.ConnectorType] =
      AwsError.unwrapOptionField("connectorType", connectorType)
    def getConnectorLabel: ZIO[Any, AwsError, ConnectorLabel] =
      AwsError.unwrapOptionField("connectorLabel", connectorLabel)
    def getConnectionMode
        : ZIO[Any, AwsError, zio.aws.appflow.model.ConnectionMode] =
      AwsError.unwrapOptionField("connectionMode", connectionMode)
    def getCredentialsArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("credentialsArn", credentialsArn)
    def getConnectorProfileProperties: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ConnectorProfileProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "connectorProfileProperties",
      connectorProfileProperties
    )
    def getCreatedAt: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getPrivateConnectionProvisioningState: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.PrivateConnectionProvisioningState.ReadOnly
    ] = AwsError.unwrapOptionField(
      "privateConnectionProvisioningState",
      privateConnectionProvisioningState
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorProfile
  ) extends zio.aws.appflow.model.ConnectorProfile.ReadOnly {
    override val connectorProfileArn: Optional[ConnectorProfileArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorProfileArn())
        .map(value =>
          zio.aws.appflow.model.primitives.ConnectorProfileArn(value)
        )
    override val connectorProfileName: Optional[ConnectorProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorProfileName())
        .map(value =>
          zio.aws.appflow.model.primitives.ConnectorProfileName(value)
        )
    override val connectorType: Optional[zio.aws.appflow.model.ConnectorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorType())
        .map(value => zio.aws.appflow.model.ConnectorType.wrap(value))
    override val connectorLabel: Optional[ConnectorLabel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorLabel())
        .map(value => zio.aws.appflow.model.primitives.ConnectorLabel(value))
    override val connectionMode
        : Optional[zio.aws.appflow.model.ConnectionMode] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionMode())
      .map(value => zio.aws.appflow.model.ConnectionMode.wrap(value))
    override val credentialsArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.credentialsArn())
      .map(value => zio.aws.appflow.model.primitives.ARN(value))
    override val connectorProfileProperties
        : Optional[zio.aws.appflow.model.ConnectorProfileProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorProfileProperties())
        .map(value =>
          zio.aws.appflow.model.ConnectorProfileProperties.wrap(value)
        )
    override val createdAt: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.appflow.model.primitives.Date(value))
    override val lastUpdatedAt: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.appflow.model.primitives.Date(value))
    override val privateConnectionProvisioningState: Optional[
      zio.aws.appflow.model.PrivateConnectionProvisioningState.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.privateConnectionProvisioningState())
      .map(value =>
        zio.aws.appflow.model.PrivateConnectionProvisioningState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ConnectorProfile
  ): zio.aws.appflow.model.ConnectorProfile.ReadOnly = new Wrapper(impl)
}
